% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_metrics.R
\name{ROC}
\alias{ROC}
\title{AUC and ROC Curves Data}
\usage{
ROC(tag, score, multis = NA)
}
\arguments{
\item{tag}{Vector. Real known label}

\item{score}{Vector. Predicted value or model's result}

\item{multis}{Data.frame. Containing columns with each category score
(only used when more than 2 categories coexist)}
}
\value{
List with ROC's results, area under the curve (AUC) and their CI.
}
\description{
This function calculates ROC Curves and AUC values with 95\% confidence
range. It also works for multi-categorical models.
}
\section{Plot Results}{

To plot results, use the \code{mplot_roc()} function.
}

\examples{
data(dfr) # Results for AutoML Predictions
lapply(dfr[c(1, 2)], head)

# ROC Data for Binomial Model
roc1 <- ROC(dfr$class2$tag, dfr$class2$scores)
lapply(roc1, head)

# ROC Data for Multi-Categorical Model
roc2 <- ROC(dfr$class3$tag, dfr$class3$score,
  multis = subset(dfr$class3, select = -c(tag, score))
)
lapply(roc2, head)
}
\seealso{
Other Machine Learning: 
\code{\link{conf_mat}()},
\code{\link{export_results}()},
\code{\link{gain_lift}()},
\code{\link{h2o_automl}()},
\code{\link{h2o_predict_MOJO}()},
\code{\link{h2o_selectmodel}()},
\code{\link{impute}()},
\code{\link{iter_seeds}()},
\code{\link{lasso_vars}()},
\code{\link{model_metrics}()},
\code{\link{model_preprocess}()},
\code{\link{msplit}()}

Other Model metrics: 
\code{\link{conf_mat}()},
\code{\link{errors}()},
\code{\link{gain_lift}()},
\code{\link{loglossBinary}()},
\code{\link{model_metrics}()}
}
\concept{Machine Learning}
\concept{Model metrics}
