% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_labs.R
\name{init_labs}
\alias{init_labs}
\title{Initialize labelr Attributes}
\usage{
init_labs(data, max.unique.vals = 5000)
}
\arguments{
\item{data}{the data.frame that you will be labeling via functions like
\code{add_val_labs} and \code{add_name_labs}.}

\item{max.unique.vals}{constrains the variables that may receive value labels
to those whose total unique values do not exceed the integer value supplied
to this argument. Note that labelr sets a hard ceiling of 5000 on the total
number of unique value labels that any variable is permitted to have under
any circumstance, as labelr is primarily intended for interactive use with
moderately-sized (<=~1M-row) data.frames.}
}
\value{
a data.frame with initial placeholder labelr meta-data added.
}
\description{
\code{init_labs} pre-populates a data.frame with "placeholder" labelr label meta-
data, which will be overwritten if/when you explicitly assign your own
preferred label attributes.
}
\details{
\code{init_labs} is used inside other labelr functions but is not intended for
interactive use at the console.
}
\examples{
# make toy demographic (gender, race, etc.) data set
set.seed(555)
df <- make_demo_data(n = 1000) # another labelr:: function
df2 <- init_labs(df) # df2 is not df
get_all_lab_atts(df) # this is df; is not df2
get_all_lab_atts(df2) # this is df2
}
