% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_labs_att.R
\name{get_labs_att}
\alias{get_labs_att}
\title{Return Specified Label Attribute, if Present}
\usage{
get_labs_att(data, att)
}
\arguments{
\item{data}{the data.frame you are checking for the presence (or absence)
of labelr meta-data.}

\item{att}{the specific label meta-data you are looking for. Default of NULL
will return any and all meta-data with name substring "name.labs",
"val.labs", or "factor." (period is part of the substring).}
}
\value{
A list.
}
\description{
\code{get_labs_att} returns the specified piece of labelr lab(el) attribute meta-
data information if it is present.
}
\examples{
# make toy demographic (gender, raceth, etc.) data set
set.seed(555)
df <- make_demo_data(n = 1000) # another labelr:: function
# let's add variable VALUE labels for variable "raceth"
df <- add_val_labs(df,
  vars = "raceth", vals = c(1:7),
  labs = c("White", "Black", "Hispanic", "Asian", "AIAN", "Multi", "Other"),
  max.unique.vals = 50
)

}
