% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/has_quant_labs.R
\name{has_quant_labs}
\alias{has_quant_labs}
\title{Is this an \code{add_quant_labs()}-style Value-labeled Variable (Column)?}
\usage{
has_quant_labs(data, var)
}
\arguments{
\item{data}{a data.frame.}

\item{var}{the unquoted name of the variable (column) to check for the
presence of \code{add_quant_labs()}-style numerical range-based value labels.}
}
\value{
A 1L logical.
}
\description{
Determine whether a specific variable of a data.frame has value labels
associated with it that were added using \code{add_quant_labs()} or \code{add_quant1()}.
}
\details{
\code{hql} is a compact alias for \code{has_quant_labs}: they do the same thing, and
the former is easier to type
}
\examples{
# copy mtcars to mt2 and assign various types of value labels
mt2 <- mtcars

# add 1-to-1 value labels
mt2 <- add_val_labs(
  data = mt2,
  vars = "am",
  vals = c(0, 1),
  labs = c("automatic", "manual")
)

has_val_labs(mt2, am) # TRUE, it does
has_m1_labs(mt2, am) # FALSE, they are NOT add_m1_lab()-style
has_quant_labs(mt2, am) # FALSE, they are NOT add_quant_labs() -style

# add many-to-1 value labels
mt2 <- add_m1_lab(
  data = mt2,
  vars = "gear",
  vals = 4:5,
  lab = "4+"
)

has_val_labs(mt2, gear) # TRUE, it does
has_m1_labs(mt2, gear) # TRUE, they ARE add_m1_lab()-style
has_quant_labs(mt2, gear) # FALSE, they NOT not add_quant_labs() -style

# add quartile-based numerical range value labels
mt2 <- add_quant_labs(
  data = mt2,
  vars = "disp",
  qtiles = 4
)

has_val_labs(mt2, disp) # TRUE, it does
has_m1_labs(mt2, disp) # FALSE, they are NOT add_m1_lab()-style
has_quant_labs(mt2, disp) # TRUE, they ARE add_quant_labs() -style
}
