% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_with.R
\name{update_variable_labels_with}
\alias{update_variable_labels_with}
\alias{update_value_labels_with}
\title{Update variable/value labels with a function}
\usage{
update_variable_labels_with(.data, .fn, .cols = dplyr::everything(), ...)

update_value_labels_with(.data, .fn, .cols = dplyr::everything(), ...)
}
\arguments{
\item{.data}{A data frame, or data frame extension (e.g. a tibble)}

\item{.fn}{A function used to transform the variable/value labels of the
selected \code{.cols}.}

\item{.cols}{Columns to update; defaults to all columns. Use tidy selection.}

\item{...}{additional arguments passed onto \code{.fn}.}
}
\description{
Update variable/value labels with a function
}
\examples{
df <- iris \%>\%
  set_variable_labels(
    Sepal.Length = "Length of sepal",
    Sepal.Width = "Width of sepal",
    Petal.Length = "Length of petal",
    Petal.Width = "Width of petal",
    Species = "Species"
  )
df$Species <- to_labelled(df$Species)
df \%>\% look_for()
df \%>\%
  update_variable_labels_with(toupper) \%>\%
  look_for()
df \%>\%
  update_variable_labels_with(toupper, .cols = dplyr::starts_with("S")) \%>\%
  look_for()
df \%>\%
  update_value_labels_with(toupper) \%>\%
  look_for()
}
