% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-creation.R
\name{get_layer}
\alias{get_layer}
\title{Retrieves a layer based on either its name (unique) or index.}
\usage{
get_layer(object, name = NULL, index = NULL)
}
\arguments{
\item{object}{Keras model object}

\item{name}{String, name of layer.}

\item{index}{Integer, index of layer (1-based). Also valid are negative
values, which count from the end of model.}
}
\value{
A layer instance.
}
\description{
Indices are based on order of horizontal graph traversal (bottom-up) and are
1-based. If \code{name} and \code{index} are both provided, \code{index} will take
precedence.
}
\seealso{
Other model functions: \cr
\code{\link{get_config}()} \cr
\code{\link{get_state_tree}()} \cr
\code{\link{keras_model}()} \cr
\code{\link{keras_model_sequential}()} \cr
\code{\link{pop_layer}()} \cr
\code{\link{set_state_tree}()} \cr
\code{\link{summary.keras.src.models.model.Model}()} \cr
}
\concept{model functions}
