% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Callback.R
\name{Callback}
\alias{Callback}
\title{Define a custom \code{Callback} class}
\usage{
Callback(
  classname,
  on_epoch_begin = NULL,
  on_epoch_end = NULL,
  on_train_begin = NULL,
  on_train_end = NULL,
  on_train_batch_begin = NULL,
  on_train_batch_end = NULL,
  on_test_begin = NULL,
  on_test_end = NULL,
  on_test_batch_begin = NULL,
  on_test_batch_end = NULL,
  on_predict_begin = NULL,
  on_predict_end = NULL,
  on_predict_batch_begin = NULL,
  on_predict_batch_end = NULL,
  ...,
  public = list(),
  private = list(),
  inherit = NULL,
  parent_env = parent.frame()
)
}
\arguments{
\item{classname}{String, the name of the custom class. (Conventionally, CamelCase).}

\item{on_epoch_begin}{\if{html}{\out{<div class="sourceCode r">}}\preformatted{\\(epoch, logs = NULL)
}\if{html}{\out{</div>}}

Called at the start of an epoch.

Subclasses should override for any actions to run. This function should
only be called during TRAIN mode.

Args:
\itemize{
\item \code{epoch}: Integer, index of epoch.
\item \code{logs}: Named List. Currently no data is passed to this argument for this
method but that may change in the future.
}}

\item{on_epoch_end}{\if{html}{\out{<div class="sourceCode r">}}\preformatted{\\(epoch, logs = NULL)
}\if{html}{\out{</div>}}

Called at the end of an epoch.

Subclasses should override for any actions to run. This function should
only be called during TRAIN mode.

Args:
\itemize{
\item \code{epoch}: Integer, index of epoch.
\item \code{logs}: Named List, metric results for this training epoch, and for the
validation epoch if validation is performed. Validation result
keys are prefixed with \code{val_}. For training epoch, the values of
the \code{Model}'s metrics are returned. Example:
\code{list(loss = 0.2, accuracy = 0.7)}.
}}

\item{on_train_begin}{\if{html}{\out{<div class="sourceCode">}}\preformatted{\\(logs = NULL)
}\if{html}{\out{</div>}}

Called at the beginning of training.

Subclasses should override for any actions to run.

Args:
\itemize{
\item \code{logs}: Named list. Currently no data is passed to this argument for this
method but that may change in the future.
}}

\item{on_train_end}{\if{html}{\out{<div class="sourceCode">}}\preformatted{\\(logs = NULL)
}\if{html}{\out{</div>}}

Called at the end of training.

Subclasses should override for any actions to run.

Args:
\itemize{
\item \code{logs}: Named list. Currently the output of the last call to
\code{on_epoch_end()} is passed to this argument for this method but
that may change in the future.
}}

\item{on_train_batch_begin}{\if{html}{\out{<div class="sourceCode">}}\preformatted{\\(batch, logs = NULL)
}\if{html}{\out{</div>}}

Called at the beginning of a training batch in \code{fit()} methods.

Subclasses should override for any actions to run.

Note that if the \code{steps_per_execution} argument to \code{compile} in
\code{Model} is set to \code{N}, this method will only be called every
\code{N} batches.

Args:
\itemize{
\item \code{batch}: Integer, index of batch within the current epoch.
\item \code{logs}: Named list. Currently no data is passed to this argument for this
method but that may change in the future.
}}

\item{on_train_batch_end}{\if{html}{\out{<div class="sourceCode">}}\preformatted{\\(batch, logs=NULL)
}\if{html}{\out{</div>}}

Called at the end of a training batch in \code{fit()} methods.

Subclasses should override for any actions to run.

Note that if the \code{steps_per_execution} argument to \code{compile} in
\code{Model} is set to \code{N}, this method will only be called every
\code{N} batches.

Args:
\itemize{
\item \code{batch}: Integer, index of batch within the current epoch.
\item \code{logs}: Named list. Aggregated metric results up until this batch.
}}

\item{on_test_begin}{\if{html}{\out{<div class="sourceCode r">}}\preformatted{\\(logs = NULL)
}\if{html}{\out{</div>}}

Called at the beginning of evaluation or validation.

Subclasses should override for any actions to run.

Args:
\itemize{
\item \code{logs}: Named list. Currently no data is passed to this argument for this
method but that may change in the future.
}}

\item{on_test_end}{\if{html}{\out{<div class="sourceCode r">}}\preformatted{\\(logs = NULL)
}\if{html}{\out{</div>}}

Called at the end of evaluation or validation.

Subclasses should override for any actions to run.

Args:
\itemize{
\item \code{logs}: Named list. Currently the output of the last call to
\code{on_test_batch_end()} is passed to this argument for this method
but that may change in the future.
}}

\item{on_test_batch_begin}{\if{html}{\out{<div class="sourceCode r">}}\preformatted{\\(batch, logs = NULL)
}\if{html}{\out{</div>}}

Called at the beginning of a batch in \code{evaluate()} methods.

Also called at the beginning of a validation batch in the \code{fit()}
methods, if validation data is provided.

Subclasses should override for any actions to run.

Note that if the \code{steps_per_execution} argument to \code{compile()} in
\code{Model} is set to \code{N}, this method will only be called every
\code{N} batches.

Args:
\itemize{
\item \code{batch}: Integer, index of batch within the current epoch.
\item \code{logs}: Named list. Currently no data is passed to this argument for this
method but that may change in the future.
}}

\item{on_test_batch_end}{\if{html}{\out{<div class="sourceCode r">}}\preformatted{\\(batch, logs = NULL)
}\if{html}{\out{</div>}}

Called at the end of a batch in \code{evaluate()} methods.

Also called at the end of a validation batch in the \code{fit()}
methods, if validation data is provided.

Subclasses should override for any actions to run.

Note that if the \code{steps_per_execution} argument to \code{compile()} in
\code{Model} is set to \code{N}, this method will only be called every
\code{N} batches.

Args:
\itemize{
\item \code{batch}: Integer, index of batch within the current epoch.
\item \code{logs}: Named list. Aggregated metric results up until this batch.
}}

\item{on_predict_begin}{\if{html}{\out{<div class="sourceCode r">}}\preformatted{\\(logs = NULL)
}\if{html}{\out{</div>}}

Called at the beginning of prediction.

Subclasses should override for any actions to run.

Args:
\itemize{
\item \code{logs}: Named list. Currently no data is passed to this argument for this
method but that may change in the future.
}}

\item{on_predict_end}{\if{html}{\out{<div class="sourceCode r">}}\preformatted{\\(logs = NULL)
}\if{html}{\out{</div>}}

Called at the end of prediction.

Subclasses should override for any actions to run.

Args:
\itemize{
\item \code{logs}: Named list. Currently no data is passed to this argument for this
method but that may change in the future.
}}

\item{on_predict_batch_begin}{\if{html}{\out{<div class="sourceCode r">}}\preformatted{\\(batch, logs = NULL)
}\if{html}{\out{</div>}}

Called at the beginning of a batch in \code{predict()} methods.

Subclasses should override for any actions to run.

Note that if the \code{steps_per_execution} argument to \code{compile()} in
\code{Model} is set to \code{N}, this method will only be called every
\code{N} batches.

Args:
\itemize{
\item \code{batch}: Integer, index of batch within the current epoch.
\item \code{logs}: Named list. Currently no data is passed to this argument for this
method but that may change in the future.
}}

\item{on_predict_batch_end}{\if{html}{\out{<div class="sourceCode r">}}\preformatted{\\(batch, logs = NULL)
}\if{html}{\out{</div>}}

Called at the end of a batch in \code{predict()} methods.

Subclasses should override for any actions to run.

Note that if the \code{steps_per_execution} argument to \code{compile} in
\code{Model} is set to \code{N}, this method will only be called every
\code{N} batches.

Args:
\itemize{
\item \code{batch}: Integer, index of batch within the current epoch.
\item \code{logs}: Named list. Aggregated metric results up until this batch.
}}

\item{..., public}{Additional methods or public members of the custom class.}

\item{private}{Named list of R objects (typically, functions) to include in
instance private environments. \code{private} methods will have all the same
symbols in scope as public methods (See section "Symbols in Scope"). Each
instance will have it's own \code{private} environment. Any objects
in \code{private} will be invisible from the Keras framework and the Python
runtime.}

\item{inherit}{What the custom class will subclass. By default, the base keras class.}

\item{parent_env}{The R environment that all class methods will have as a grandparent.}
}
\value{
A function that returns the custom \code{Callback} instances,
similar to the builtin callback functions.
}
\description{
Callbacks can be passed to keras methods such as \code{fit()}, \code{evaluate()}, and
\code{predict()} in order to hook into the various stages of the model training,
evaluation, and inference lifecycle.

To create a custom callback, call \code{Callback()} and
override the method associated with the stage of interest.
}
\section{Examples}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{training_finished <- FALSE
callback_mark_finished <- Callback("MarkFinished",
  on_train_end = function(logs = NULL) \{
    training_finished <<- TRUE
  \}
)

model <- keras_model_sequential(input_shape = c(1)) |>
  layer_dense(1)
model |> compile(loss = 'mean_squared_error')
model |> fit(op_ones(c(1, 1)), op_ones(c(1, 1)),
             callbacks = callback_mark_finished())
stopifnot(isTRUE(training_finished))
}\if{html}{\out{</div>}}

All R function custom methods (public and private) will have the
following symbols in scope:
\itemize{
\item \code{self}: the \code{Layer} instance.
\item \code{super}: the \code{Layer} superclass.
\item \code{private}: An R environment specific to the class instance.
Any objects defined here will be invisible to the Keras framework.
\item \verb{__class__} the current class type object. This will also be available as
an alias symbol, the value supplied to \code{Layer(classname = )}
}
}

\section{Attributes (accessible via \verb{self$})}{
\itemize{
\item \code{params}: Named list, Training parameters
(e.g. verbosity, batch size, number of epochs, ...).
\item \code{model}: Instance of \code{Model}.
Reference of the model being trained.
}

The \code{logs} named list that callback methods
take as argument will contain keys for quantities relevant to
the current batch or epoch (see method-specific docstrings).
}

\section{Symbols in scope}{
All R function custom methods (public and private) will have the
following symbols in scope:
\itemize{
\item \code{self}: The custom class instance.
\item \code{super}: The custom class superclass.
\item \code{private}: An R environment specific to the class instance.
Any objects assigned here are invisible to the Keras framework.
\item \verb{__class__} and \code{as.symbol(classname)}: the custom class type object.
}
}

\seealso{
\itemize{
\item \url{https://keras.io/api/callbacks/base_callback#callback-class}
}

Other callbacks: \cr
\code{\link{callback_backup_and_restore}()} \cr
\code{\link{callback_csv_logger}()} \cr
\code{\link{callback_early_stopping}()} \cr
\code{\link{callback_lambda}()} \cr
\code{\link{callback_learning_rate_scheduler}()} \cr
\code{\link{callback_model_checkpoint}()} \cr
\code{\link{callback_reduce_lr_on_plateau}()} \cr
\code{\link{callback_remote_monitor}()} \cr
\code{\link{callback_swap_ema_weights}()} \cr
\code{\link{callback_tensorboard}()} \cr
\code{\link{callback_terminate_on_nan}()} \cr
}
\concept{callbacks}
