% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{pad_sequences}
\alias{pad_sequences}
\title{Pads sequences to the same length.}
\usage{
pad_sequences(
  sequences,
  maxlen = NULL,
  dtype = "int32",
  padding = "pre",
  truncating = "pre",
  value = 0
)
}
\arguments{
\item{sequences}{List of sequences (each sequence is a list of integers).}

\item{maxlen}{Optional Int, maximum length of all sequences. If not provided,
sequences will be padded to the length of the longest individual
sequence.}

\item{dtype}{(Optional, defaults to \code{"int32"}). Type of the output sequences.
To pad sequences with variable length strings, you can use \code{object}.}

\item{padding}{String, "pre" or "post" (optional, defaults to \code{"pre"}):
pad either before or after each sequence.}

\item{truncating}{String, "pre" or "post" (optional, defaults to \code{"pre"}):
remove values from sequences larger than
\code{maxlen}, either at the beginning or at the end of the sequences.}

\item{value}{Float or String, padding value. (Optional, defaults to 0.)}
}
\value{
Array with shape \verb{(len(sequences), maxlen)}
}
\description{
This function transforms a list (of length \code{num_samples})
of sequences (lists of integers)
into a 2D NumPy array of shape \verb{(num_samples, num_timesteps)}.
\code{num_timesteps} is either the \code{maxlen} argument if provided,
or the length of the longest sequence in the list.

Sequences that are shorter than \code{num_timesteps}
are padded with \code{value} until they are \code{num_timesteps} long.

Sequences longer than \code{num_timesteps} are truncated
so that they fit the desired length.

The position where padding or truncation happens is determined by
the arguments \code{padding} and \code{truncating}, respectively.
Pre-padding or removing values from the beginning of the sequence is the
default.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{sequence <- list(c(1), c(2, 3), c(4, 5, 6))
pad_sequences(sequence)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{##      [,1] [,2] [,3]
## [1,]    0    0    1
## [2,]    0    2    3
## [3,]    4    5    6

}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pad_sequences(sequence, value=-1)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{##      [,1] [,2] [,3]
## [1,]   -1   -1    1
## [2,]   -1    2    3
## [3,]    4    5    6

}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pad_sequences(sequence, padding='post')
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{##      [,1] [,2] [,3]
## [1,]    1    0    0
## [2,]    2    3    0
## [3,]    4    5    6

}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pad_sequences(sequence, maxlen=2)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{##      [,1] [,2]
## [1,]    0    1
## [2,]    2    3
## [3,]    5    6

}\if{html}{\out{</div>}}
}
\seealso{
\itemize{
\item \url{https://keras.io/api/data_loading/timeseries#padsequences-function}
}

Other utils: \cr
\code{\link{audio_dataset_from_directory}()} \cr
\code{\link{clear_session}()} \cr
\code{\link{config_disable_interactive_logging}()} \cr
\code{\link{config_disable_traceback_filtering}()} \cr
\code{\link{config_enable_interactive_logging}()} \cr
\code{\link{config_enable_traceback_filtering}()} \cr
\code{\link{config_is_interactive_logging_enabled}()} \cr
\code{\link{config_is_traceback_filtering_enabled}()} \cr
\code{\link{get_file}()} \cr
\code{\link{get_source_inputs}()} \cr
\code{\link{image_array_save}()} \cr
\code{\link{image_dataset_from_directory}()} \cr
\code{\link{image_from_array}()} \cr
\code{\link{image_load}()} \cr
\code{\link{image_smart_resize}()} \cr
\code{\link{image_to_array}()} \cr
\code{\link{layer_feature_space}()} \cr
\code{\link{normalize}()} \cr
\code{\link{set_random_seed}()} \cr
\code{\link{split_dataset}()} \cr
\code{\link{text_dataset_from_directory}()} \cr
\code{\link{timeseries_dataset_from_array}()} \cr
\code{\link{to_categorical}()} \cr
\code{\link{zip_lists}()} \cr
}
\concept{utils}
