% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{config_set_floatx}
\alias{config_set_floatx}
\title{Set the default float dtype.}
\usage{
config_set_floatx(value)
}
\arguments{
\item{value}{String; \code{'bfloat16'}, \code{'float16'}, \code{'float32'}, or \code{'float64'}.}
}
\value{
No return value, called for side effects.
}
\description{
Set the default float dtype.
}
\section{Note}{
It is not recommended to set this to \code{"float16"} for training,
as this will likely cause numeric stability issues.
Instead, mixed precision, which leverages
a mix of \code{float16} and \code{float32}. It can be configured by calling
\code{keras3::keras$mixed_precision$set_dtype_policy('mixed_float16')}.
}

\section{Examples}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{config_floatx()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## [1] "float32"

}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{config_set_floatx('float64')
config_floatx()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## [1] "float64"

}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Set it back to float32
config_set_floatx('float32')
}\if{html}{\out{</div>}}
}

\section{Raises}{
ValueError: In case of invalid value.
}

\seealso{
\itemize{
\item \url{https://keras.io/api/utils/config_utils#setfloatx-function}
}

Other config backend: \cr
\code{\link{config_backend}()} \cr
\code{\link{config_epsilon}()} \cr
\code{\link{config_floatx}()} \cr
\code{\link{config_image_data_format}()} \cr
\code{\link{config_set_epsilon}()} \cr
\code{\link{config_set_image_data_format}()} \cr

Other backend: \cr
\code{\link{clear_session}()} \cr
\code{\link{config_backend}()} \cr
\code{\link{config_epsilon}()} \cr
\code{\link{config_floatx}()} \cr
\code{\link{config_image_data_format}()} \cr
\code{\link{config_set_epsilon}()} \cr
\code{\link{config_set_image_data_format}()} \cr

Other config: \cr
\code{\link{config_backend}()} \cr
\code{\link{config_disable_interactive_logging}()} \cr
\code{\link{config_disable_traceback_filtering}()} \cr
\code{\link{config_enable_interactive_logging}()} \cr
\code{\link{config_enable_traceback_filtering}()} \cr
\code{\link{config_enable_unsafe_deserialization}()} \cr
\code{\link{config_epsilon}()} \cr
\code{\link{config_floatx}()} \cr
\code{\link{config_image_data_format}()} \cr
\code{\link{config_is_interactive_logging_enabled}()} \cr
\code{\link{config_is_traceback_filtering_enabled}()} \cr
\code{\link{config_set_backend}()} \cr
\code{\link{config_set_epsilon}()} \cr
\code{\link{config_set_image_data_format}()} \cr
}
\concept{backend}
\concept{config}
\concept{config backend}
