% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activations.R
\name{activation_elu}
\alias{activation_elu}
\title{Exponential Linear Unit.}
\usage{
activation_elu(x, alpha = 1)
}
\arguments{
\item{x}{Input tensor.}

\item{alpha}{Numeric. See description for details.}
}
\value{
A tensor, the result from applying the activation to the input tensor \code{x}.
}
\description{
The exponential linear unit (ELU) with \code{alpha > 0} is defined as:
\itemize{
\item \code{x} if \code{x > 0}
\item \code{alpha * exp(x) - 1} if \code{x < 0}
}

ELUs have negative values which pushes the mean of the activations
closer to zero.

Mean activations that are closer to zero enable faster learning as they
bring the gradient closer to the natural gradient.
ELUs saturate to a negative value when the argument gets smaller.
Saturation means a small derivative which decreases the variation
and the information that is propagated to the next layer.
}
\section{Reference}{
\itemize{
\item \href{https://arxiv.org/abs/1511.07289}{Clevert et al., 2016}
}
}

\seealso{
\itemize{
\item \url{https://keras.io/api/layers/activations#elu-function}
}

Other activations: \cr
\code{\link{activation_exponential}()} \cr
\code{\link{activation_gelu}()} \cr
\code{\link{activation_hard_sigmoid}()} \cr
\code{\link{activation_leaky_relu}()} \cr
\code{\link{activation_linear}()} \cr
\code{\link{activation_log_softmax}()} \cr
\code{\link{activation_mish}()} \cr
\code{\link{activation_relu}()} \cr
\code{\link{activation_relu6}()} \cr
\code{\link{activation_selu}()} \cr
\code{\link{activation_sigmoid}()} \cr
\code{\link{activation_silu}()} \cr
\code{\link{activation_softmax}()} \cr
\code{\link{activation_softplus}()} \cr
\code{\link{activation_softsign}()} \cr
\code{\link{activation_tanh}()} \cr
}
\concept{activations}
