% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-persistence.R
\name{save_model_tf}
\alias{save_model_tf}
\alias{load_model_tf}
\title{Save/Load models using SavedModel format}
\usage{
save_model_tf(
  object,
  filepath,
  overwrite = TRUE,
  include_optimizer = TRUE,
  signatures = NULL,
  options = NULL
)

load_model_tf(filepath, custom_objects = NULL, compile = TRUE)
}
\arguments{
\item{object}{Model object to save}

\item{filepath}{File path}

\item{overwrite}{Overwrite existing file if necessary}

\item{include_optimizer}{If \code{TRUE}, save optimizer's state.}

\item{signatures}{Signatures to save with the SavedModel. Please see the signatures
argument in \code{tf$saved_model$save} for details.}

\item{options}{Optional \code{tf$saved_model$SaveOptions} object that specifies options
for saving to SavedModel}

\item{custom_objects}{Mapping class names (or function names) of custom
(non-Keras) objects to class/functions (for example, custom metrics
or custom loss functions). This mapping can be done with the dict()
function of reticulate.}

\item{compile}{Whether to compile the model after loading.}
}
\description{
Save/Load models using SavedModel format
}
\seealso{
Other model persistence: 
\code{\link{get_weights}()},
\code{\link{model_to_json}()},
\code{\link{model_to_yaml}()},
\code{\link{save_model_hdf5}()},
\code{\link{save_model_weights_hdf5}()},
\code{\link{serialize_model}()}
}
\concept{model persistence}
