% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regress.R
\name{regressModuleUI}
\alias{regressModuleUI}
\title{regressModuleUI: shiny modulde UI for linear regression.}
\usage{
regressModuleUI(id)
}
\arguments{
\item{id}{id}
}
\value{
Shiny modulde UI for linear regression.
}
\description{
Shiny modulde UI for linear regression.
}
\details{
Shiny modulde UI for linear regression.
}
\examples{
library(shiny)
library(DT)
library(data.table)
library(jstable)
ui <- fluidPage(
  sidebarLayout(
    sidebarPanel(
      regressModuleUI("linear")
    ),
    mainPanel(
      DTOutput("lineartable")
    )
  )
)

server <- function(input, output, session) {
  data <- reactive(mtcars)
  data.label <- reactive(jstable::mk.lev(mtcars))

  out_linear <- callModule(regressModule2, "linear",
    data = data, data_label = data.label,
    data_varStruct = NULL
  )

  output$lineartable <- renderDT({
    datatable(out_linear()$table, rownames = T, caption = out_linear()$caption)
  })
}
}
