% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FileRepeatedInput.R
\name{FileRepeated}
\alias{FileRepeated}
\title{FileRepeated: File upload server module for repeated measure analysis.}
\usage{
FileRepeated(input, output, session, nfactor.limit = 20)
}
\arguments{
\item{input}{input}

\item{output}{output}

\item{session}{session}

\item{nfactor.limit}{nfactor limit to include, Default: 20}
}
\value{
File upload server module for repeated measure analysis.
}
\description{
File upload server module for repeated measure analysis.
}
\details{
File upload server module for repeated measure analysis.
}
\examples{
library(shiny)
library(DT)
library(data.table)
library(readxl)
library(jstable)
ui <- fluidPage(
  sidebarLayout(
    sidebarPanel(
      FileRepeatedInput("datafile")
    ),
    mainPanel(
      tabsetPanel(
        type = "pills",
        tabPanel("Data", DTOutput("data")),
        tabPanel("Label", DTOutput("data_label", width = "100\%"))
      )
    )
  )
)

server <- function(input, output, session) {
  data <- callModule(FileRepeated, "datafile")

  output$data <- renderDT({
    data()$data
  })

  output$label <- renderDT({
    data()$label
  })
}
}
