% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampling_heatmap.R
\name{sampling_heatmap}
\alias{sampling_heatmap}
\title{Sampling heat map plot}
\usage{
sampling_heatmap(
  irace_results,
  param_names,
  sizes = c(0, 0),
  iterations = NULL,
  only_elite = TRUE,
  filename = NULL
)
}
\arguments{
\item{irace_results}{The data generated when loading the \code{.Rdata} file created by \code{irace} (or the filename of that file).}

\item{param_names}{(\code{character()}) Parameters to be included in the plot. Example:
\code{c("algorithm","alpha","rho","q0","rasrank")}.}

\item{sizes}{Numeric vector that indicated the number of intervals to be considered for numerical
parameters. This argument is positional with respect to param_names. By default,
numerical parameters are displayed using 10 intervals.
(example sizes = c(0,10))}

\item{iterations}{Numeric vector, iteration number that should be included in the plot
(example: iterations = c(1,4,5))}

\item{only_elite}{logical (default TRUE), only print elite configurations.}

\item{filename}{(\code{character(1)}) File name to save the plot, for example \code{"~/path/example/filename.png"}.}
}
\value{
sampling heat map plot
}
\description{
Heatmap that displays the frequency of sampling values of two parameters.
}
\examples{
iraceResults <- read_logfile(system.file(package="irace", "exdata",
                                         "irace-acotsp.Rdata", mustWork = TRUE))
sampling_heatmap(iraceResults, param_names=c("beta", "alpha"))
sampling_heatmap(iraceResults, param_names=c("beta", "alpha"), iterations = c(3,4))
sampling_heatmap(iraceResults, param_names=c("beta", "alpha"), only_elite = FALSE)
}
