% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/informativeSCI-package.R
\docType{package}
\name{informativeSCI-package}
\alias{informativeSCI}
\alias{informativeSCI-package}
\title{informativeSCI: Informative Simultaneous Confidence Intervals}
\description{
Calculation of informative simultaneous confidence intervals for graphical described multiple test procedures and given information weights. Bretz et al. (2009) \doi{10.1002/sim.3495} and Brannath et al. (2024) \doi{10.48550/arXiv.2402.13719}. Furthermore, exploration of the behavior of the informative bounds in dependence of the information weights. Comparisons with compatible bounds are possible. Strassburger and Bretz (2008) \doi{10.1002/sim.3338}.
}
\details{
The main function of the package is the \link{informSCI}-function for
calculating informative lower simultaneous confidence bounds for a given
graphical test procedure and given information weights. The
\link{explore_q}-function can help to find the right information weights
for the \link{informSCI}-algorithm. The \link{inExactSCI}- and
\link{notInExactSCI}-functions can help to determine how accurate a
(numerical) approximation of the true informative lower SCI-bounds is.
}
\references{
F. Bretz, W. Maurer, W. Brannath, M. Posch: A graphical approach
to sequentially rejective multiple test procedures. Statistics in Medicine
28.4 (2009), pp. 586-604.

K. Strassburger, F. Bretz: Compatible simultaneous lower confidence bounds
for the Holm procedure and other Bonferroni based closed tests. Statistics
in Medicine 27.4 (2008), pp. 4914-4927.
S. Schmidt, W. Brannath: Informative Simultaneous Confidence Intervals
in Hierarchical Testing. Methods of Information in Medicine 53.4 (2014),
pp. 278–283.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/LianeKluge/informativeSCI}
  \item Report bugs at \url{https://github.com/LianeKluge/informativeSCI/issues}
}

}
\author{
\strong{Maintainer}: Liane Kluge \email{liane@uni-bremen.de}

Other contributors:
\itemize{
  \item Werner Brannath [contributor]
  \item Martin Scharpenberg [contributor]
}

}
