% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ei_index.R
\name{ei_index}
\alias{ei_index}
\title{Krackhardt and Stern’s E-I Index (\code{ei_index})}
\usage{
ei_index(
  ego_id,
  ego_measure,
  alter_ego,
  alter_measure,
  prefix = NULL,
  suffix = NULL
)
}
\arguments{
\item{ego_id}{A vector of unique ego identifiers located in an ego dataframe. If using data objects created by \code{\link{ego_netwrite}}, this should be the data frame entitled \code{egos}.}

\item{ego_measure}{A vector of attributes corresponding to each ego}

\item{alter_ego}{A vector of ego identifiers located in an alter dataframe. If using data objects created by \code{\link{ego_netwrite}}, this should be the data frame entitled \code{alters}.}

\item{alter_measure}{A vector of attributes corresponding to each alter}

\item{prefix}{A character value indicating the desired prefix for the calculated E-I measure}

\item{suffix}{A character value indicating the desired suffix for the calculated E-I measure}
}
\value{
\code{ei_index} returns a dataframe of vectors that include the ego identifier and the ei-index value for the selected attribute
}
\description{
Linear transformation of the proportion homophilous measure (Krackhardt and Stern 1988; Perry et al. 2018)
}
\examples{

# Run `ego_netwrite`
ngq_nw <- ego_netwrite(egos = ngq_egos,
                      ego_id = ngq_egos$ego_id,

                      alters = ngq_alters,
                      alter_id = ngq_alters$alter_id,
                      alter_ego = ngq_alters$ego_id,

                      max_alters = 10,
                      alter_alter = ngq_aa,
                      aa_ego = ngq_aa$ego_id,
                      i_elements = ngq_aa$alter1,
                      j_elements = ngq_aa$alter2,
                      directed = FALSE)


# Calculate E-I Index for Race
race_ei <- ei_index(ego_id = ngq_nw$egos$ego_id, ego_measure = ngq_nw$egos$race,
                   alter_ego = ngq_nw$alters$ego_id, alter_measure = ngq_nw$alters$race,
                   prefix = "race")

race_ei
}
