% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rasch-Model.R
\name{clr_tests}
\alias{clr_tests}
\title{Conditional Likelihood Ratio Tests (CLR)}
\usage{
clr_tests(dat.items, dat.exo = NULL, model = c("RM", "PCM"))
}
\arguments{
\item{dat.items}{A data frame with the responses to the items.}

\item{dat.exo}{A data frame consisting of exogenous factor variables.}

\item{model}{If model="RM" a Rasch model will be fitted,
if model="PCM" a partial credit model for polytomous items is used.}
}
\value{
matrix with test statistics, df and p values.
}
\description{
The conditional likelihood ratio tests compare item parameters in low and high score groups
for an overall test of homogeneity, and in groups defined by the levels of exogenous factors
for tests of no differential item functioning (DIF).
}
\examples{
#CLR overall test and test of  no DIF for agegrp and sex
clr_tests(amts[,4:13],amts[,2:3])
}
\references{
Andersen, E.B. (1973). A goodness of fit test for the Rasch model. \emph{Psychometrika}, 38, 123-140.
}
\author{
Marianne Mueller
}
