% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifcb_download_dashboard_data.R
\name{ifcb_download_dashboard_data}
\alias{ifcb_download_dashboard_data}
\title{Download IFCB data files from an IFCB Dashboard}
\usage{
ifcb_download_dashboard_data(
  dashboard_url,
  samples,
  file_types,
  dest_dir,
  convert_filenames = FALSE,
  convert_adc = FALSE,
  parallel_downloads = 5,
  sleep_time = 2,
  multi_timeout = 120,
  max_retries = 3,
  quiet = FALSE
)
}
\arguments{
\item{dashboard_url}{Character. The base URL of the IFCB dashboard (e.g., \code{"https://ifcb-data.whoi.edu"}).
If no subpath (e.g., \verb{/data/} or \verb{/mvco/}) is included, \verb{/data/} will be added automatically. For the "features" and "autoclass" \code{file_types}, the dataset name needs to be
included in the url (e.g. \code{"https://ifcb-data.whoi.edu/mvco/"}).}

\item{samples}{Character vector. The IFCB sample identifiers (e.g., \code{"IFCB1_2014_188_222013"} or \code{"D20220807T025424_IFCB010"}).}

\item{file_types}{Character vector. Specifies which file types to download.
Allowed values: \code{"blobs"}, \code{"features"}, \code{"autoclass"}, \code{"roi"}, \code{"zip"}, \code{"hdr"}, \code{"adc"}.}

\item{dest_dir}{Character. The directory where downloaded files will be saved.}

\item{convert_filenames}{Logical. If \code{TRUE}, converts filenames of the old format \code{"IFCBxxx_YYYY_DDD_HHMMSS"}
to the new format (\code{DYYYYMMDDTHHMMSS_IFCBXXX} or \code{IYYYYMMDDTHHMMSS_IFCBXXX}). Default is \code{FALSE}.
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}}

\item{convert_adc}{Logical. If \code{TRUE}, adjusts \code{.adc} files from older IFCB instruments
(IFCB1–6, with filenames in the format \code{"IFCBxxx_YYYY_DDD_HHMMSS"}) by inserting
four empty columns after column 7 to match the newer format. Default is \code{FALSE}.
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}}

\item{parallel_downloads}{Integer. The number of files to download in parallel per batch.
This helps manage network load and system performance. Default is \code{10}.}

\item{sleep_time}{A numeric value indicating the number of seconds to wait between each batch of downloads. Default is \code{2}.}

\item{multi_timeout}{Numeric. The maximum time in seconds that the \code{curl} multi-download request
will wait for a response before timing out. This helps prevent
hanging downloads in case of slow or unresponsive servers. Default is \code{120} seconds.}

\item{max_retries}{An integer specifying the maximum number of attempts to retrieve data in case the server is unable to handle the request. Default is 3.}

\item{quiet}{Logical. If TRUE, suppresses messages about the progress and completion of the download process. Default is FALSE.}
}
\value{
This function does not return a value. It performs the following actions:
\itemize{
\item Downloads the requested files into \code{dest_dir}.
\item If \code{convert_adc = TRUE}, modifies ADC files in place by inserting four empty columns after column 7.
\item Displays messages indicating the download status.
}
}
\description{
This function downloads specified IFCB data files from a given IFCB Dashboard URL.
It supports optional filename conversion and ADC file adjustments from the old IFCB file format.
}
\details{
This function can download several files in parallel if the server allows it. The download parameters can be adjusted using the \code{parallel_downloads}, \code{sleep_time} and \code{multi_timeout} arguments.

If \code{convert_filenames = TRUE} \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}, filenames in the \code{"IFCBxxx_YYYY_DDD_HHMMSS"} format (used by IFCB1-6)
will be converted to \code{IYYYYMMDDTHHMMSS_IFCBXXX}, ensuring compatibility with blob extraction in \code{ifcb-analysis} (Sosik & Olson, 2007), which identified the old \code{.adc} format by the first letter of the filename.

If \code{convert_adc = TRUE} \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} and \code{convert_filenames = TRUE} \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}, the \code{"IFCBxxx_YYYY_DDD_HHMMSS"} format will instead be converted to
\code{DYYYYMMDDTHHMMSS_IFCBXXX}. Additionally, \code{.adc} files will be modified to include four empty columns
(PMT-A peak, PMT-B peak, PMT-C peak, and PMT-D peak), aligning them with the structure of modern \code{.adc} files
for full compatibility with \code{ifcb-analysis}.
}
\examples{
\dontrun{
ifcb_download_dashboard_data(
  dashboard_url = "https://ifcb-data.whoi.edu/mvco/",
  samples = "IFCB1_2014_188_222013",
  file_types = c("blobs", "autoclass"),
  dest_dir = "data",
  convert_filenames = FALSE,
  convert_adc = FALSE
)
}

}
\references{
Sosik, H. M. and Olson, R. J. (2007), Automated taxonomic classification of phytoplankton sampled with imaging-in-flow cytometry. Limnol. Oceanogr: Methods 5, 204–216.
}
