% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayes.R
\name{rmbayes}
\alias{rmbayes}
\title{Bayes test for random mating with known genotypes}
\usage{
rmbayes(
  nvec,
  lg = TRUE,
  alpha = NULL,
  beta = NULL,
  nburn = 10000,
  niter = 10000,
  type = c("auto", "allo")
)
}
\arguments{
\item{nvec}{A vector containing the observed genotype counts,
where \code{nvec[[i]]} is the number of individuals with genotype
\code{i-1}. This should be of length \code{ploidy+1}.}

\item{lg}{A logical. Should we return the log Bayes factor (\code{TRUE})
or the Bayes factor (\code{FALSE})?}

\item{alpha}{The concentration hyperparameters of the gamete frequencies
under the null of random mating. Should be length ploidy/2 + 1.}

\item{beta}{The concentration hyperparameters of the genotype frequencies
under the alternative of no random mating. Should be length ploidy + 1.}

\item{nburn}{The number of iterations in the Gibbs sampler to burn-in.}

\item{niter}{The number of sampling iterations in the Gibbs sampler.}

\item{type}{If \code{alpha} is \code{NULL}, then the default priors depend
on if you have autopolyploids (\code{"auto"}) or allopolyploids
(\code{"allo"}).}
}
\description{
Bayes test for random mating with known genotypes
}
\examples{
set.seed(1)
ploidy <- 8

## Simulate under the null
p <- stats::runif(ploidy / 2 + 1)
p <- p / sum(p)
q <- stats::convolve(p, rev(p), type = "open")

## See BF increase
nvec <- c(stats::rmultinom(n = 1, size = 100, prob = q))
rmbayes(nvec = nvec)

nvec <- c(stats::rmultinom(n = 1, size = 1000, prob = q))
rmbayes(nvec = nvec)

nvec <- c(stats::rmultinom(n = 1, size = 10000, prob = q))
rmbayes(nvec = nvec)

## Simulate under the alternative
q <- stats::runif(ploidy + 1)
q <- q / sum(q)

## See BF decrease
nvec <- c(stats::rmultinom(n = 1, size = 100, prob = q))
rmbayes(nvec = nvec)

nvec <- c(stats::rmultinom(n = 1, size = 1000, prob = q))
rmbayes(nvec = nvec)

nvec <- c(stats::rmultinom(n = 1, size = 10000, prob = q))
rmbayes(nvec = nvec)

}
\references{
\itemize{
\item{Gerard D (2022). "Bayesian tests for random mating in autopolyploids." \emph{bioRxiv}. \doi{10.1101/2022.08.11.503635}.}
}
}
\author{
David Gerard
}
