% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_honda2023.R
\name{load_honda2023}
\alias{load_honda2023}
\title{Load Caco2 QSPR predictions from Honda et al. 2023}
\usage{
load_honda2023(overwrite = FALSE, exclude_oad = TRUE, target.env = .GlobalEnv)
}
\arguments{
\item{overwrite}{Only matters if load.image=FALSE. If overwrite=TRUE then
existing data in chem.physical_and_invitro.data will be replaced by any
prediction in Honda et al. (2023) that is for the same chemical and
property. If overwrite=FALSE (DEFAULT) then new data for the same chemical
and property are ignored.}

\item{exclude_oad}{Include the chemicals only within the applicability domain.
If exclude_oad=TRUE (DEFAULT) chemicals outside the applicability domain do not
have their predicted values loaded.}

\item{target.env}{The environment where the new
\code{\link{chem.physical_and_invitro.data}} is loaded. Defaults to global environment.}
}
\value{
\item{data.frame}{An updated version of
\code{\link{chem.physical_and_invitro.data}}.}
}
\description{
This function returns an updated version of 
\code{\link{chem.physical_and_invitro.data}}
that includes Caco2 Pab predictions from the Random Forest quantitative 
structure-property relationship (QSPR) models developed and
presented in Honda et al. 2023, included in table \code{\link{honda2023.qspr}}.
}
\details{
Note that because Pab is not required for most HTTK models, changing
the number of chemicals for which a value is available will not change the
number of chemicals which are listed with the \code{\link{get_cheminfo}}
command. Use the command \code{\link{reset_httk}} to return to the initial 
(measured only) \code{\link{chem.physical_and_invitro.data}} (for all
parameters).
}
\examples{

\donttest{
# For chemicals with Honda et al. (2023) Caco2 Pab QSPR predictions, 
# add them to our chemical information wherever measured values are 
# unavailable:
load_honda2023()

# Or, for chemicals with Honda et al. (2023) QSPR predictions, add them to
# our chemical information but overwrite measured values where we had them:
load_honda2023(overwrite=TRUE) 

# Now let us reset the chemical data to the initial version:
reset_httk()
}                        

}
\seealso{
\code{\link{reset_httk}}

\code{\link{get_cheminfo}}
}
\author{
John Wambaugh
}
