% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival_operations.R
\name{apply_hr}
\alias{apply_hr}
\title{Apply a Hazard Ratio}
\usage{
apply_hr(dist, hr, log_hr = FALSE)
}
\arguments{
\item{dist}{A survival distribution.}

\item{hr}{A hazard ratio to be applied.}

\item{log_hr}{If \code{TRUE}, the hazard ratio is exponentiated
before being applied.}
}
\value{
A \code{surv_ph} object.
}
\description{
Proportional reduce or increase the hazard rate of a
distribution.
}
\examples{

dist1 <- define_surv_dist(distribution = "exp", rate = .25)
ph_dist <- apply_hr(dist1, 0.5)

}
