// (c) The HDF Group
#ifndef MERCURY_THREAD_POOL_H
#define MERCURY_THREAD_POOL_H
#include "mercury_queue.h"
#include "mercury_thread.h"
#include "mercury_thread_condition.h"
typedef struct hg_thread_pool hg_thread_pool_t;
struct hg_thread_pool {
    unsigned int sleeping_worker_count;
    HG_QUEUE_HEAD(hg_thread_work) queue;
    int               shutdown;
    hg_thread_mutex_t mutex;
    hg_thread_cond_t  cond;
};
struct hg_thread_work {
    hg_thread_func_t func;
    void            *args;
    HG_QUEUE_ENTRY(hg_thread_work) entry;
};
#ifdef __cplusplus
extern "C" {
#endif
HG_UTIL_PUBLIC int hg_thread_pool_init(unsigned int thread_count, hg_thread_pool_t **pool);
HG_UTIL_PUBLIC int hg_thread_pool_destroy(hg_thread_pool_t *pool);
static HG_UTIL_INLINE int hg_thread_pool_post(hg_thread_pool_t *pool, struct hg_thread_work *work);
static HG_UTIL_INLINE int
hg_thread_pool_post(hg_thread_pool_t *pool, struct hg_thread_work *work)
{
    int ret = HG_UTIL_SUCCESS;
    if (!pool || !work)
        return HG_UTIL_FAIL;
    if (!work->func)
        return HG_UTIL_FAIL;
    hg_thread_mutex_lock(&pool->mutex);
    if (pool->shutdown) {
        ret = HG_UTIL_FAIL;
        goto unlock;
    }
    HG_QUEUE_PUSH_TAIL(&pool->queue, work, entry);
    if (pool->sleeping_worker_count && (hg_thread_cond_signal(&pool->cond) != HG_UTIL_SUCCESS))
        ret = HG_UTIL_FAIL;
unlock:
    hg_thread_mutex_unlock(&pool->mutex);
    return ret;
}
#ifdef __cplusplus
}
#endif
#endif
