% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brdg_continuous.R
\name{brdg_continuous}
\alias{brdg_continuous}
\title{Continuous Summary Table Bridges}
\usage{
brdg_continuous(cards, by = NULL, statistic, include, variable)
}
\arguments{
\item{cards}{(\code{card})\cr
An ARD object of class \code{"card"} typically created with \verb{cards::ard_*()} functions.}

\item{by}{(\code{string})\cr
string indicating the stratifying column}

\item{statistic}{(named \code{list})\cr
named list of summary statistic names}

\item{include}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Variables to include in the summary table. Default is \code{everything()}.}

\item{variable}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
A single column from \code{data}. Variable name of the continuous column to be summarized.}
}
\value{
a gtsummary object
}
\description{
Bridge function for converting \code{tbl_continuous()} cards to basic gtsummary objects.
This bridge function converts the 'cards' object to a format suitable to
pass to \code{brdg_summary()}: no \verb{pier_*()} functions required.
}
\examples{
library(cards)

bind_ard(
  # the primary ARD with the results
  ard_continuous(trial, by = grade, variables = age),
  # add missing and attributes ARD
  ard_missing(trial, by = grade, variables = age),
  ard_attributes(trial, variables = c(grade, age))
) |>
  # adding the column name
  dplyr::mutate(
    gts_column =
      ifelse(!context \%in\% "attributes", "stat_0", NA_character_)
  ) |>
  brdg_continuous(
    variable = "age",
    include = "grade",
    statistic = list(grade = "{median} ({p25}, {p75})")
 ) |>
 as_tibble()
}
