% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_flex_table.R
\name{as_flex_table}
\alias{as_flex_table}
\title{Convert gtsummary object to a flextable object}
\usage{
as_flex_table(x, include = everything(), return_calls = FALSE, ...)
}
\arguments{
\item{x}{(\code{gtsummary})\cr
An object of class `"gtsummary"}

\item{include}{Commands to include in output. Input may be a vector of
quoted or unquoted names. tidyselect and gtsummary select helper
functions are also accepted.
Default is \code{everything()}.}

\item{return_calls}{Logical. Default is \code{FALSE}. If \code{TRUE}, the calls are returned
as a list of expressions.}

\item{...}{Not used}
}
\value{
A 'flextable' object
}
\description{
Function converts a gtsummary object to a flextable object.
A user can use this function if they wish to add customized formatting
available via the flextable functions. The flextable output is particularly
useful when combined with R markdown with Word output, since the gt package
does not support Word.
}
\details{
The \code{as_flex_table()} function supports bold and italic markdown syntax in column headers
and spanning headers (\code{'**'} and \code{'_'} only).
Text wrapped in double stars (\code{'**bold**'}) will be made bold, and text between single
underscores (\code{'_italic_'}) will be made italic.
No other markdown syntax is supported and the double-star and underscore cannot be combined.
To further style your table, you may convert the table to flextable with
\code{as_flex_table()}, then utilize any of the flextable functions.
}
\examples{
\dontshow{if (gtsummary:::is_pkg_installed("flextable", reference_pkg = "gtsummary")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
trial |>
  select(trt, age, grade) |>
  tbl_summary(by = trt) |>
  add_p() |>
  as_flex_table()
\dontshow{\}) # examplesIf}
}
\author{
Daniel D. Sjoberg
}
