% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_stop_times_patterns.R
\name{get_stop_times_patterns}
\alias{get_stop_times_patterns}
\title{Get stop times patterns}
\usage{
get_stop_times_patterns(
  gtfs,
  trip_id = NULL,
  type = "spatial",
  sort_sequence = FALSE
)
}
\arguments{
\item{gtfs}{A GTFS object, as created by \code{\link[=read_gtfs]{read_gtfs()}}.}

\item{trip_id}{A character vector including the \code{trip_id}s to have their
\code{stop_times} entries analyzed. If \code{NULL} (the default), the function
analyses the pattern of every \code{trip_id} in the GTFS.}

\item{type}{A string specifying the type of patterns to be analyzed. Either
\code{"spatial"} (the default) or "spatiotemporal".}

\item{sort_sequence}{A logical specifying whether to sort timetables by
\code{stop_sequence}. Defaults to \code{FALSE}, otherwise spec-compliant feeds, in
which timetables points are already ordered by \code{stop_sequence}, would be
penalized through longer processing times. Pattern identification based on
unordered timetables may result in multiple ids identifying what would be
the same pattern, had the table been ordered.}
}
\value{
A \code{data.table} associating each \code{trip_id} to a \code{pattern_id}.
}
\description{
Identifies spatial and spatiotemporal patterns within the \code{stop_times}
table. Please see the details to understand what a "pattern" means in each of
these cases.
}
\section{Details}{

Two trips are assigned to the same spatial \code{pattern_id} if they travel along
the same sequence of stops. They are assigned to the same spatiotemporal
\code{pattern_id}, on the other hand, if they travel along the same sequence of
stops and they take the same time between stops. Please note that, in such
case, only the time between stops is taken into account, and the time that
the trip started is ignored (e.g. if two trips depart from stop A and follow
the same sequence of stops to arrive at stop B, taking both 1 hour to do so,
their spatiotemporal pattern will be considered the same, even if one
departed at 6 am and another at 7 am). Please also note that the
\code{stop_sequence} field is currently ignored - which means that two stops are
considered to follow the same sequence if one is listed right below the
other on the \code{stop_times} table (e.g. if trip X lists stops A followed by
stop B with \code{stop_sequence}s 1 and 2, and trip Y lists stops A followed by
stop B with \code{stop_sequence}s 1 and 3, they are assigned to the same
\code{pattern_id}).
}

\examples{
data_path <- system.file("extdata/ber_gtfs.zip", package = "gtfstools")

gtfs <- read_gtfs(data_path)

patterns <- get_stop_times_patterns(gtfs)
head(patterns)

# use the trip_id argument to control which trips are analyzed
patterns <- get_stop_times_patterns(
  gtfs,
  trip_id = c("143765658", "143765659", "143765660")
)
patterns

# use the type argument to control the type of pattern analyzed
patterns <- get_stop_times_patterns(
  gtfs,
  trip_id = c("143765658", "143765659", "143765660"),
  type = "spatiotemporal"
)
patterns

}
