% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_by_spatial_extent.R
\name{filter_by_spatial_extent}
\alias{filter_by_spatial_extent}
\title{Filter a GTFS object using a spatial extent}
\usage{
filter_by_spatial_extent(
  gtfs,
  geom,
  spatial_operation = sf::st_intersects,
  keep = TRUE
)
}
\arguments{
\item{gtfs}{A GTFS object, as created by \code{\link[=read_gtfs]{read_gtfs()}}.}

\item{geom}{An \code{sf} object. Describes the spatial extent used to filter the
data.}

\item{spatial_operation}{A spatial operation function from the set of
options listed in \link[sf:geos_binary_pred]{geos_binary_pred} (check the
\href{https://en.wikipedia.org/wiki/DE-9IM}{DE-I9M} Wikipedia entry for the
definition of each function). Defaults to \code{\link[sf:geos_binary_pred]{sf::st_intersects}}, which
tests if the shapes and trips have ANY intersection with the object
specified in \code{geom}. Please note that \code{geom} is passed as the \code{x} argument
of these functions.}

\item{keep}{A logical. Whether the entries related to the shapes and trips
selected by the given spatial operation should be kept or dropped (defaults
to \code{TRUE}, which keeps the entries).}
}
\value{
The GTFS object passed to the \code{gtfs} parameter, after the filtering
process.
}
\description{
Filters a GTFS object using a spatial extent (passed as an \code{sf} object),
keeping (or dropping) entries related to shapes and trips whose geometries
are selected through a specified spatial operation.
}
\examples{
data_path <- system.file("extdata/spo_gtfs.zip", package = "gtfstools")
gtfs <- read_gtfs(data_path)

shape_id <- "68962"
shape_sf <- convert_shapes_to_sf(gtfs, shape_id)
bbox <- sf::st_bbox(shape_sf)
object.size(gtfs)

# keeps entries that intersect with the specified polygon
smaller_gtfs <- filter_by_spatial_extent(gtfs, bbox)
object.size(smaller_gtfs)

# drops entries that intersect with the specified polygon
smaller_gtfs <- filter_by_spatial_extent(gtfs, bbox, keep = FALSE)
object.size(smaller_gtfs)

# uses a different function to filter the gtfs
smaller_gtfs <- filter_by_spatial_extent(
  gtfs,
  bbox,
  spatial_operation = sf::st_contains
)
object.size(smaller_gtfs)

}
\seealso{
Other filtering functions: 
\code{\link{filter_by_agency_id}()},
\code{\link{filter_by_route_id}()},
\code{\link{filter_by_route_type}()},
\code{\link{filter_by_service_id}()},
\code{\link{filter_by_sf}()},
\code{\link{filter_by_shape_id}()},
\code{\link{filter_by_stop_id}()},
\code{\link{filter_by_time_of_day}()},
\code{\link{filter_by_trip_id}()},
\code{\link{filter_by_weekday}()}
}
\concept{filtering functions}
