% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_by_route_id.R
\name{filter_by_route_id}
\alias{filter_by_route_id}
\title{Filter GTFS object by \code{route_id}}
\usage{
filter_by_route_id(gtfs, route_id, keep = TRUE)
}
\arguments{
\item{gtfs}{A GTFS object, as created by \code{\link[=read_gtfs]{read_gtfs()}}.}

\item{route_id}{A character vector. The \code{route_id}s used to filter the data.}

\item{keep}{A logical. Whether the entries related to the specified
\code{route_id}s should be kept or dropped (defaults to \code{TRUE}, which keeps the
entries).}
}
\value{
The GTFS object passed to the \code{gtfs} parameter, after the filtering
process.
}
\description{
Filters a GTFS object by \code{route_id}s, keeping (or dropping) the relevant
entries in each file.
}
\examples{
data_path <- system.file("extdata/spo_gtfs.zip", package = "gtfstools")
gtfs <- read_gtfs(data_path)
route_ids <- c("6450-51", "CPTM L11")

object.size(gtfs)

# keeps entries related to passed route_ids
smaller_gtfs <- filter_by_route_id(gtfs, route_ids)
object.size(smaller_gtfs)

# drops entries related to passed route_ids
smaller_gtfs <- filter_by_route_id(gtfs, route_ids, keep = FALSE)
object.size(smaller_gtfs)

}
\seealso{
Other filtering functions: 
\code{\link{filter_by_agency_id}()},
\code{\link{filter_by_route_type}()},
\code{\link{filter_by_service_id}()},
\code{\link{filter_by_sf}()},
\code{\link{filter_by_shape_id}()},
\code{\link{filter_by_spatial_extent}()},
\code{\link{filter_by_stop_id}()},
\code{\link{filter_by_time_of_day}()},
\code{\link{filter_by_trip_id}()},
\code{\link{filter_by_weekday}()}
}
\concept{filtering functions}
