% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/firls.R
\name{firls}
\alias{firls}
\title{Least-squares linear-phase FIR filter design}
\usage{
firls(n, f, a, w = rep(1L, length(a)/2))
}
\arguments{
\item{n}{filter order (1 less than the length of the filter). Must be even.
If odd, it is incremented by one.}

\item{f}{vector of frequency points in the range from 0 to 1, where 1
corresponds to the Nyquist frequency. Each band is specified by two
frequencies, so the vector must have an even length. .}

\item{a}{vector of the same length as \code{f} containing the desired
amplitude at each of the points specified in \code{f}.}

\item{w}{weighting function that contains one value for each band that
weights the mean squared error in that band. \code{w} must be half the
length of \code{f}.}
}
\value{
The FIR filter coefficients, a vector of length \code{n + 1}, of
  class \code{Ma}.
}
\description{
Produce a linear phase filter such that the integral of the weighted mean
squared error in the specified bands is minimized.
}
\examples{
freqz(firls(255, c(0, 0.25, 0.3, 1), c(1, 1, 0, 0)))

}
\seealso{
\code{\link{Ma}}, \code{\link{filter}}, \code{\link{fftfilt}},
  \code{\link{fir1}}
}
\author{
Quentin Spencer, \email{qspencer@ieee.org}.\cr
  Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
