% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vtrapz.R
\name{visualize_vtrapz}
\alias{visualize_vtrapz}
\alias{visualize_vtrapz.numeric}
\alias{visualize_vtrapz.fv}
\alias{visualize_vtrapz.fvlist}
\alias{visualize_vtrapz.density}
\alias{visualize_vtrapz.ecdf}
\alias{visualize_vtrapz.function}
\title{Visualize \code{\link[=vtrapz]{vtrapz()}} and \code{\link[=cumvtrapz]{cumvtrapz()}}}
\usage{
visualize_vtrapz(
  x,
  y,
  x_smooth,
  y_smooth,
  x_labels,
  y_labels,
  yname,
  draw.rect,
  draw.v,
  label.v,
  draw.cumv,
  label.cumv,
  ...
)

\method{visualize_vtrapz}{numeric}(
  x,
  y,
  x_smooth = x,
  y_smooth = y,
  x_labels,
  y_labels,
  yname,
  draw.rect = TRUE,
  draw.v = draw.rect,
  label.v = "Average Vertical Height",
  draw.cumv = TRUE,
  label.cumv = "Cumulative Average Vertical Height",
  ...
)

\method{visualize_vtrapz}{fv}(x, ...)

\method{visualize_vtrapz}{fvlist}(x, ...)

\method{visualize_vtrapz}{density}(x, ...)

\method{visualize_vtrapz}{ecdf}(x, ...)

\method{visualize_vtrapz}{`function`}(x, ..., n = 513L)
}
\arguments{
\item{x}{see \strong{Usage}}

\item{y}{\link[base]{numeric} \link[base]{vector}}

\item{x_smooth, y_smooth}{\link[base]{numeric} \link[base]{vector}s,
smoothed \eqn{x} and \eqn{y} values,
to beautify the \link[geomtextpath]{geom_textpath} of a \link[stats]{stepfun}}

\item{x_labels, y_labels}{..}

\item{yname}{(optional) \link[base]{character} scalar, name of function}

\item{draw.rect}{\link[base]{logical} scalar,
whether to plot the rectangle, default \code{TRUE}}

\item{draw.v}{\link[base]{logical} scalar,
whether to plot the average vertical height \code{\link[=vtrapz]{vtrapz()}},
default is determined by parameter \code{draw.rect}.}

\item{label.v, label.cumv}{\link[base]{character} scalars}

\item{draw.cumv}{\link[base]{logical} scalar, whether to plot the cumulative average vertical height \code{\link[=cumvtrapz]{cumvtrapz()}}, default \code{TRUE}}

\item{...}{additional parameters, currently of no use}

\item{n}{\link[base]{integer}, number of \eqn{x}-values at which to evaluate,
only applicable when the input is the return of function \link[stats]{splinefun}.}
}
\value{
The \code{S3} generic function \code{\link[=visualize_vtrapz]{visualize_vtrapz()}} returns a \link[ggplot2]{ggplot} object.
}
\description{
Visualize (cumulative) average vertical height of trapezoidal integration.
}
\keyword{internal}
