% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ga_anova.R
\name{ga_anova}
\alias{ga_anova}
\title{ANOVA table from a generalised additive model (\code{gam})}
\usage{
ga_anova(
  data,
  Y_value,
  Fixed_Factor,
  Smooth_Factor,
  Random_Factor = NULL,
  Nodes = NULL,
  ...
)
}
\arguments{
\item{data}{a data frame where categorical independent variables are converted to factors using \code{as.factor()} first. The function will throw errors without this.}

\item{Y_value}{name of column containing quantitative (dependent) variable, provided within "quotes".}

\item{Fixed_Factor}{name(s) of categorical fixed factors (independent variables) provided within quotes (e.g., "A") or as a vector if more than one (e.g., c("A", "B"). Convert to factors first with \code{as.factor}.}

\item{Smooth_Factor}{the continuous variable to fit smoothly with a basis function, provided within "quotes" (only 1 Smooth_Factor allowed).}

\item{Random_Factor}{name(s) of random factors to be provided in "quotes" (only 1 Random_Factor allowed). Convert to factor with \code{as.factor} first.}

\item{Nodes}{number of nodes (the parameter \code{k} in \code{gam}).}

\item{...}{any additional variables to pass on to \code{gam} or \code{anova}}
}
\value{
ANOVA table of class "anova" and "data.frame".
}
\description{
One of two functions for fitting generalised additive models (\code{gam}) with the \href{https://CRAN.R-project.org/package=mgcv}{\code{mgcv} package}. It will use the \code{gam()} function in \code{mgcv} for ANOVA designs with \strong{up to two categorical fixed factors} (with two or more levels; \code{Fixed_Factor}), and \strong{exactly one factor is a continuous variable} (e.g. time), which is called \code{Smooth_Factor}.
\enumerate{
\item \code{\link{ga_model}}
\item \code{\link{ga_anova}}
}
}
\details{
A smooth function is fitted with factor-wise smooth basis function (\verb{by = }). A default value for number of nodes (the argument \code{k} in \code{gam}) may work, but a specific number can be provided using the \code{Nodes} argument. The model is fit using the \code{REML} method. When two categorical fixed factors are provided, an interaction term is included for main effects and smooth basis functions.

If a \code{Random_Factor} is also provided, it is fitted using \code{bs = "re"} smooth.
}
\examples{
#with zooplankton data
ga_anova(data = data_zooplankton,
Y_value = "log(density_adj)",
Fixed_Factor = "taxon",
Smooth_Factor = "day")


}
