% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Encode.R
\name{encode}
\alias{encode}
\alias{encode.sf}
\alias{encode.data.frame}
\title{Encode}
\usage{
encode(obj, ...)

\method{encode}{sf}(obj, strip = FALSE, ...)

\method{encode}{data.frame}(obj, lon = NULL, lat = NULL, byrow = FALSE, ...)
}
\arguments{
\item{obj}{either an \code{sf} object or \code{data.frame}}

\item{...}{other parameters passed to methods}

\item{strip}{logical indicating if \code{sf} attributes should be stripped. 
Useful if you want to reduce the size even further, but you will lose the 
spatial attributes associated with the \code{sf} object}

\item{lon}{vector of longitudes}

\item{lat}{vector of latitudes}

\item{byrow}{logical indicating if the encoding should be done for each row}
}
\value{
\code{sfencoded} object
}
\description{
Encodes coordinates into an encoded polyline.
}
\details{
The function assumes Google Web Mercator projection (WSG 84 / EPSG:3857 / EPSG:900913)
for inputs and outputs.

Will work with
\itemize{
  \item{\code{sf} and \code{sfc} objects} directly
  \item{\code{data.frames}} - It will attempt to find lat & lon coordinates, 
  or you can explicitely define them using the \code{lat} and \code{lon} arguments
}
}
\note{
When an \code{sfencoded} object is colulmn-subset using \code{`[`} and 
the encoded column is retained, the attributes of the column will remain. This 
is different behaviour to standard subsetting of \code{data.frames}, where all 
attributes are dropped by default. See examples.

When encoding an \code{sf} object, only the XY dimensions will be used,
the Z or M (3D and/or Measure) dimensions are dropped.
}
\examples{

## data.frame
df <- data.frame(polygonId = c(1,1,1,1),
  lineId = c(1,1,1,1),
  lon = c(-80.190, -66.118, -64.757, -80.190),
  lat = c(26.774, 18.466, 32.321, 26.774))
  
## on a data.frame, it will attemp to find the lon & lat columns
encode(df)

## use byrow = TRUE to convert each row individually
encode(df, byrow = TRUE)


\dontrun{

## sf objects
library(sf)
nc <- sf::st_read(system.file("shape/nc.shp", package="sf"))

encoded <- encode(nc)

## view attributes
attributes(encoded) 

## view attributes of subset object
attributes(encoded[, c("AREA", "PERIMETER", "geometry")])

## view attributes without encoded column
attributes(encoded[, c("AREA", "PERIMETER")])

## strip attributes
encodedLite <- encode(nc, strip = TRUE)

attributes(encodedLite)

## view attributes of subset lite object
attributes(encodedLite[, c("AREA", "PERIMETER", "geometry")])

## view attributes without encoded column
attributes(encodedLite[, c("AREA", "PERIMETER")])
}

}
\seealso{
\link{encodeCoordinates}
}
