% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpus.R
\name{gce_vm_gpu}
\alias{gce_vm_gpu}
\title{Launch a GPU enabled instance}
\usage{
gce_vm_gpu(..., return_dots = FALSE)
}
\arguments{
\item{...}{arguments passed to \link{gce_vm}}

\item{return_dots}{Only return the settings, do not call \link{gce_vm}}
}
\value{
A VM object
}
\description{
Helper function that fills in some defaults passed to \link{gce_vm}
}
\details{
If not specified, this function will enter defaults to get a GPU instance up and running.

\itemize{
  \item \code{acceleratorCount: 1}
  \item \code{acceleratorType: "nvidia-tesla-p4"}
  \item \code{scheduling: list(onHostMaintenance = "TERMINATE", automaticRestart = TRUE)}
  \item \code{image_project: "deeplearning-platform-release"}
  \item \code{image_family: "tf-latest-cu92"}
  \item \code{predefined_type: "n1-standard-8"}
  \item \code{metadata: "install-nvidia-driver" = "True"}
 }
}
\seealso{
\href{Deep Learning VM}{https://cloud.google.com/deep-learning-vm/docs/quickstart-cli}

Other GPU instances: \code{\link{gce_check_gpu}},
  \code{\link{gce_list_gpus}}
}
\concept{GPU instances}
