% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/machineType.R
\name{gce_set_machinetype}
\alias{gce_set_machinetype}
\title{Changes the machine type for a stopped instance to the machine type specified in the request.}
\usage{
gce_set_machinetype(predefined_type, cpus, memory, instance,
  project = gce_get_global_project(), zone = gce_get_global_zone())
}
\arguments{
\item{predefined_type}{A predefined machine type from \link{gce_list_machinetype}}

\item{cpus}{If not defining \code{predefined_type}, the number of CPUs}

\item{memory}{If not defining \code{predefined_type}, amount of memory}

\item{instance}{Name of the instance resource to change}

\item{project}{Project ID for this request, default as set by \link{gce_get_global_project}}

\item{zone}{The name of the zone for this request, default as set by \link{gce_get_global_zone}}
}
\value{
A zone operation job
}
\description{
Changes the machine type for a stopped instance to the machine type specified in the request.
}
\details{
Authentication scopes used by this function are:
\itemize{
  \item https://www.googleapis.com/auth/cloud-platform
\item https://www.googleapis.com/auth/compute
}
}
\seealso{
\href{https://developers.google.com/compute/docs/reference/latest/}{Google Documentation}
}
