% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_otree.R
\name{import_otree}
\alias{import_otree}
\title{Import oTree data}
\usage{
import_otree(
  path = ".",
  file_names = NULL,
  final_apps = NULL,
  final_pages = NULL,
  recursive = TRUE,
  csv = TRUE,
  onlybots = FALSE,
  del_empty = TRUE,
  info = FALSE,
  encoding = "UTF-8"
)
}
\arguments{
\item{path}{Character. The path to the files (default is the
working directory).}

\item{file_names}{Character. The name(s) of the file(s) to be imported.
If not specified, all files in the path and subfolders are imported.}

\item{final_apps}{Character.
The name(s) of the app(s) at which the participants have to finish the
experiment. If the argument final_apps is left empty, you can still call
for deleting the participants who did not finish the experiment
with \code{\link{delete_dropouts}}.}

\item{final_pages}{Character.
The name(s) of the page(s) at which the participants have to finish the
experiment. If the argument final_pages is left empty, you can still
call for deleting the participants who did not finish the experiment
with \code{\link{delete_dropouts}}.}

\item{recursive}{Logical. \code{TRUE} if the files in the path's
subfolders should also be imported.}

\item{csv}{Logical. \code{TRUE} if only CSV files should be
imported. \code{FALSE} if only Excel files should be imported.}

\item{onlybots}{Logical. \code{TRUE} if only bot-created files
should be imported.}

\item{del_empty}{Logical. \code{TRUE} if all empty cases should be deleted
from the \code{$all_apps_wide} or normal app data frames (not Time or Chats).}

\item{info}{Logical. \code{TRUE} if a brief information on the data
import should be printed.}

\item{encoding}{Character. Encoding of the CSV files that are imported.
Default is \code{"UTF-8"}.}
}
\value{
Returns a list of data frames (one data frame for each app
and \code{$all_apps_wide}) and a list of information on this list
of data frames in \code{$info}.

See detailed information on the imported files
in \code{$info$imported_files}.

If \code{$all_apps_wide} is imported, see the number of imported cases
in \code{$info$initial_n}. In this number, empty rows are
already considered. So, if empty rows are deleted
with \code{del_empty=TRUE}, \code{initial_n}
counts all rows that are not empty.
Cases that are deleted because the participants did not make it to the
last page and/or app are not subtracted from this number.

Information: Empty rows are rows without
the \code{participant._current_app_name}
variable set. Empty rows are deleted from all app data frames
and \code{$all_apps_wide} when using \code{del_empty = TRUE}. Empty rows in
the \code{$Chats} and \code{$Time} data frames are not deleted.

If old and new oTree versions are combined, the \code{$Time} data frame
contains variables called \code{participant_code}
and \code{participant__code} (the difference is in the underscores).
Caution! If there is an unusual amount of \code{NA}s,
check if everything got imported correctly.
Sometimes, the CSV or Excel file may be corrupted, and all information is
only found in one column.
}
\description{
Import data files that were created by oTree.
All files containing the pattern YYYY-MM-DD at the end
of their file names are considered oTree files.
Bot outputs are saved by oTree without the date included. Hence, to
import bot data, you must either rename the original bot files
using the YYYY-MM-DD format or use the argument \code{onlybots = TRUE}.
By using the second option, only data of bot files are imported.

Caution! Data can be downloaded from within the
session and globally at the same time. If both files are downloaded,
this can lead to the \code{$all_apps_wide} data being there twice! You can
remove duplicate data by using \code{\link{delete_duplicate}}.

Caution! When importing Excel files, this function does not check
for erroneous data structures
and will combine all data frames with the same file name patterns.
Before using the \code{CSV = FALSE} argument,
clean up your data appropriately.
}
\examples{
\dontshow{if (rlang::is_installed("withr")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Set data folder first
withr::with_dir(system.file("extdata", package = "gmoTree"), {

# Import all oTree files in this folder and its subfolders
oTree <- import_otree()

# Show the structure of the import
str(oTree, max.level = 1)

# Show the names of all imported files
oTree$info$imported_files

# Delete empty cases and delete every case of a person
# who didn't end the experiment in the app "survey"
oTree <- import_otree(
  del_empty = TRUE,
  final_apps = "survey",
  info = TRUE)

# Show the structure of the import
str(oTree, max.level = 1)

# Import bot files
import_otree(
  path = "./bot_data",
  onlybots = TRUE,
  csv = TRUE,
  info = TRUE)

# Show the structure of the import
str(oTree, max.level = 1)

# Import with file names (path separately)
oTree2 <- import_otree(
     del_empty = TRUE,
     path = "./exp_data",
     file_names = c("all_apps_wide-2023-03-27.csv",
                   "ChatMessages-2023-03-27.csv",
                   "PageTimes-2023-03-27.csv"),
     onlybots = FALSE,
     csv = TRUE,
     info = TRUE)

# Show the structure of the import
str(oTree, max.level = 1)

# Import with file names (without path separately)
oTree2 <- import_otree(
     del_empty = TRUE,
     file_names = c("exp_data/all_apps_wide-2023-03-27.csv",
                   "exp_data/ChatMessages-2023-03-27.csv",
                   "exp_data/PageTimes-2023-03-27.csv"),
     onlybots = FALSE,
     csv = TRUE,
     info = TRUE)

# Show the structure of the import
str(oTree, max.level = 1)
})
\dontshow{\}) # examplesIf}
}
\keyword{oTree}
