% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete_cases.R
\name{delete_cases}
\alias{delete_cases}
\title{Delete specific cases}
\usage{
delete_cases(
  oTree,
  pcodes = NULL,
  plabels = NULL,
  saved_vars = NULL,
  reason,
  omit = FALSE,
  info = FALSE
)
}
\arguments{
\item{oTree}{A list of data frames that were created
by \code{\link{import_otree}}.}

\item{pcodes}{Character. The value(s) of the participant.code variable of
the participants whose data should be removed.}

\item{plabels}{Character. The value(s) of the participant.label variable of
the participants whose data should be removed.}

\item{saved_vars}{Character. The name(s) of variable(s) that need(s) to be
stored in the list of information on deleted cases
in \code{$info$deleted_cases}.}

\item{reason}{Character. The reason for deletion that should be stored in
the list of information on deleted cases in \code{$info$deleted_cases}.}

\item{omit}{Logical. \code{TRUE} if the deleted cases should not be added to
the information on deleted cases in \code{$info$deleted_cases}.}

\item{info}{Logical. \code{TRUE} if a brief information on the case deletion
process should be printed.}
}
\value{
This function returns a duplicate of the original oTree list
of data frames that do not include the deleted cases.

It adds information on the deleted cases to \code{$info$deleted_cases}. (This
list is also filled by other functions.)

In this list, you can find the following information:

- \code{$codes} = A vector with the participant codes of all deleted cases.

- \code{$count} = The number of participants in \code{$codes}.

- \code{$full} and \code{$unique} = The data frames \code{$full} and \code{$unique} contain information on each deleted participant and the reason why they were deleted. The entries to the \code{$full} and the \code{$unique} data frames are the same. Columns \code{"end_app"} and \code{"end_page"} are left empty intentionally because they are only filled by the \code{\link{delete_dropouts}} function.
}
\description{
Delete specific cases from all data frames in the oTree list.

Caution 1: This function does not delete cases from the original
CSV and Excel files!

Caution 2: This function does not delete cases from custom exports
and custom data frames if these data frames do not have a variable
named participant.code!

Caution 3: This function does not delete any data from
the \code{$Chats} data frame!
(As the interpretation of chat data depends on how participants
engage with each other, the data must be deleted
with more care than deleting data in other apps.
Hence, this function does not delete data in this data frame.
Please do this manually if necessary!)
}
\examples{
# Use package-internal list of oTree data frames
oTree <- gmoTree::oTree

# Delete only one case
oTree2 <- delete_cases(oTree,
                       pcodes = "xmxl46rm",
                       reason = "requested")

# Show changes in row numbers
print(paste("Row numbers before deletion: ", nrow(oTree$all_apps_wide), nrow(oTree$survey),
nrow(oTree$Time), nrow(oTree$Chats)))

print(paste("Row numbers after deletion: ", nrow(oTree2$all_apps_wide), nrow(oTree2$survey),
nrow(oTree2$Time), nrow(oTree2$Chats)))

# Delete several cases
deletionlist <- c("4zhzdmzo", "xmxl46rm")
oTree2 <- delete_cases(oTree,
                       pcodes = deletionlist,
                       reason = "requested")

# Show row numbers again
print(paste(nrow(oTree2$all_apps_wide), nrow(oTree2$survey),
nrow(oTree2$Time), nrow(oTree2$Chats)))

# Show information on all deleted cases (also dropouts):
oTree2$info$deleted_cases$full

# Save one variable
oTree2 <- delete_cases(oTree,
  pcodes = deletionlist,
  reason = "requested",
  saved_vars = "participant._index_in_pages")

# Show row numbers again
print(paste(nrow(oTree2$all_apps_wide), nrow(oTree2$survey),
nrow(oTree2$Time), nrow(oTree2$Chats)))

# Check the "full" deletion information
oTree2$info$deleted_cases$full

# Save some variables
oTree2 <- delete_cases(oTree,
  pcodes = deletionlist,
  reason = "requested",
  saved_vars = c(
    "participant._index_in_pages",
    "participant._max_page_index"))

# Show row numbers again
print(paste(nrow(oTree2$all_apps_wide), nrow(oTree2$survey),
nrow(oTree2$Time), nrow(oTree2$Chats)))

# Check the "full" deletion information
oTree2$info$deleted_cases$full

# Get a list of all deleted cases
# (If there is already a list, the new list is added to it)
oTree2$info$deleted_cases$codes

# Show number of all deleted cases
length(oTree2$info$deleted_cases$codes)
oTree2$info$deleted_cases$count

# Delete a session and delete a single case from another session
oTree2 <- delete_sessions(oTree,
  scodes = c("vd1h01iv"),
  reason = "Server Crash", 
  saved_vars = "dictator.1.group.id_in_subsession")
oTree2 <- delete_cases(oTree2,
                       pcodes = "4zhzdmzo",
                       reason = "requested")
                       
# Check the "full" deletion information
oTree2$info$deleted_cases$full

# See codes of deleted variables
oTree2$info$deleted_cases$codes

# See number of deleted variables
oTree2$info$deleted_cases$count
}
\keyword{oTree}
