% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derived.traits.R
\name{iudt}
\alias{iudt}
\title{Derived traits for Glycan peaks in IgG for UPLC}
\usage{
iudt(data = NULL, method = "2014", print.exp.names = FALSE)
}
\arguments{
\item{data}{data frame that holds columns representing Glycans.
These column names should start with 'GP'.}

\item{method}{year of the derived traits definition. By default 2014.}

\item{print.exp.names}{If \code{TRUE} return expected column names 
representing glycans.}
}
\value{
Returns the data frame with derived traits
}
\description{
Calculates values of derived traits for Glycan peaks in IgG for UPLC
}
\details{
Calculates derived traits from basic glycan peaks. User can choose
which definition of the derived traits he will use
(see references for different versions/definitions of derived traits).
}
\references{
Jennifer E. Huffman et al. (2014)
"Comparative Performance of Four Methods for High-throughput Glycosylation Analysis of Immunoglobulin G in Genetic and Epidemiological Research*"
\doi{10.1074/mcp.M113.037465}
}
\author{
Ivo Ugrina, Frano Vučković
}
