% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getEnvironCov.gllvm.R
\name{getEnvironCov.gllvm}
\alias{getEnvironCov.gllvm}
\alias{getEnvironCov}
\alias{getEnvironCor}
\alias{getEnvironCor.gllvm}
\title{Extract species covariances due to environmental random effects from gllvm object}
\usage{
\method{getEnvironCov}{gllvm}(object, x = NULL, ...)
}
\arguments{
\item{object}{an object of class 'gllvm'.}

\item{x}{(optional) vector of covariate values to calculate the covariance for. Defaults to a vector of 1s. If both 'randomX' and random species effects are present in the model this should be a list of length two.}

\item{...}{not used}
}
\value{
Function returns the following components:
 \item{cov}{species covariances due to covariates}
 \item{trace.randomB}{ trace of the covariance matrix due to random canonical coefficients}
 \item{trace.randomB.quad}{ trace of the covariance matrix components due to squared model terms}
 \item{trace.col.eff}{ trace of the covariance matrix due to random column (species) effects}
}
\description{
Calculates the species environment covariance matrix for a gllvm object.
}
\details{
Species covariance matrix due to the environment is calculated.

Covariances due to the covariates can only be calculated when random effects are included in the model, and are thus limited to reduced rank models (those including constrained and concurrent ordinations) fitted with random slopes, models fitted with random effects via the formula interface, or the fourth corner model fitted with random slopes.
For full rank models with random slopes, i.e., with the formula interface or the fourth corner model, the covariances of species are formulated as:

 \deqn{\Sigma_e = kronecker(C\rho + (1-\rho)I_p, R),}
 
where \eqn{C} is a correlation matrix for the columns in the response (e.g., a Phylogenetic matrix), \eqn{\rho} the signal parameter, and R the covariance matrix for the random effects. Here, \deqn{I = kronecker(I_p, x)}, with x a vector of covariate values for each of the random effects, which defaults to a vector of 1s.
when there are covariate-specific phylogenetic signal parameters in the model, this is instead:

\deqn{\Sigma_e = kronecker(x_i', I_m)*bdiag(L_k)*kronecker(\Sigma_r, I_m)*bdiag(L_k')*kronecker(x_i, I_m),}

where \eqn{bdiag(L_k)} is a block-diagonal lower triangular matrix, and each \eqn{L_k} the lower triangular matrix of the covariance matrix for each covariate.

For reduced rank models, the covariance is separately defined for the different variance structures of the canonical coefficients in the package. With LV-specific variances, we have:

 \deqn{\Sigma_e = \Theta*S*\Theta',}

where \eqn{\Theta} is the matrix of loadings, and S the (diagonal) covariance matrix for the canonical coefficients. With predictor-specific variances, we instead have:

\deqn{\Sigma_e = \sum^K_{k=1} \Theta(I_d*\sigma_k^2)\Theta',}

with I_d an identity matrix for the number of constrained and informed latent variables, and \eqn{\sigma_k^2} the variance per predictor for the canonical coefficients. When correlations are included, we have:

 \deqn{\Sigma_e = kronecker(x_i', I_m)kronecker(\Sigma,\Theta\Theta')kronecker(x_i, I_m).}

Expressions for the quadratic models in the package are determined similarly but not documented here for brevity.
}
\examples{
\dontrun{
# Example with the spider dataset
data(eSpider)
y = eSpider$abund[eSpider$nonNA,]
X = eSpider$X[eSpider$nonNA,]
fit <- gllvm(y, X = scale(X), num.RR = 2, 
            randomB = "P", family = "negative.binomial")
envcov <- getEnvironCov(fit)
envcov$trace.randomB
# As proportion of variance in the model
envcov$trace.randomB/sum(envcov$trace.randomB)
}
}
\seealso{
\code{\link{getEnvironCor}} ,\code{\link{getResidualCov.gllvm}}, \code{\link{getResidualCor.gllvm}},.
}
\author{
Bert van der Veen
}
