% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename_variable.R
\name{rename_variable}
\alias{rename_variable}
\alias{rename_variable.character}
\alias{rename_variable.default}
\alias{rename_variable.git_repository}
\title{Rename a Variable}
\usage{
rename_variable(file, change, root = ".", ...)

\method{rename_variable}{character}(file, change, root = ".", ...)

\method{rename_variable}{default}(file, change, root, ...)

\method{rename_variable}{git_repository}(file, change, root, ..., stage = FALSE, force = FALSE)
}
\arguments{
\item{file}{the name of the git2rdata object. Git2rdata objects cannot
have dots in their name. The name may include a relative path. \code{file} is a
path relative to the \code{root}.
Note that \code{file} must point to a location within \code{root}.}

\item{change}{A named vector with the old names as values and the new names
as names.}

\item{root}{The root of a project. Can be a file path or a \code{git-repository}.
Defaults to the current working directory (\code{"."}).}

\item{...}{parameters used in some methods}

\item{stage}{Logical value indicating whether to stage the changes after
writing the data. Defaults to \code{FALSE}.}

\item{force}{Add ignored files. Default is FALSE.}
}
\value{
invisible \code{NULL}.
}
\description{
The raw data file contains a header with the variable names.
The metadata list the variable names and their type.
Changing a variable name and overwriting the \code{git2rdata} object with result
in an error.
Because it will look like removing an existing variable and adding a new one.
Overwriting the object with \code{strict = FALSE} potentially changes the order of
the variables, leading to a large diff.
}
\details{
This function solves this by only updating the raw data header and the
metadata.
}
\examples{

# initialise a git repo using git2r
repo_path <- tempfile("git2rdata-repo-")
dir.create(repo_path)
repo <- git2r::init(repo_path)
git2r::config(repo, user.name = "Alice", user.email = "alice@example.org")

# Create a dataframe and store it as an optimized git2rdata object.
# Note that write_vc() uses optimization by default.
# Stage and commit the git2rdata object.
ds <- data.frame(
  a = c("a1", "a2"),
  b = c("b2", "b1"),
  stringsAsFactors = TRUE
)
junk <- write_vc(ds, "rename", repo, sorting = "b", stage = TRUE)
cm <- commit(repo, "initial commit")
# check that the workspace is clean
status(repo)

# Define change.
change <- c(new_name = "a")
rename_variable(file = "rename", change = change, root = repo)
# check the changes
read_vc("rename", repo)
status(repo)
}
\seealso{
Other storage: 
\code{\link{display_metadata}()},
\code{\link{list_data}()},
\code{\link{prune_meta}()},
\code{\link{read_vc}()},
\code{\link{relabel}()},
\code{\link{rm_data}()},
\code{\link{update_metadata}()},
\code{\link{verify_vc}()},
\code{\link{write_vc}()}
}
\concept{storage}
