% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_stat_pareto.r
\name{stat_pareto}
\alias{stat_pareto}
\title{Generate a Pareto Plot with ggplot}
\usage{
stat_pareto(mapping = NULL, data = NULL, geom = "point",
  position = "identity", show.legend = NA, inherit.aes = TRUE,
  group = 1, na.rm = FALSE, point.color = "black", point.size = 2,
  line.color = "black", line.size = 0.5, bars.fill = c("red", "white"),
  ...)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link{aes}} or
\code{\link{aes_}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
   options:

   If \code{NULL}, the default, the data is inherited from the plot
   data as specified in the call to \code{\link{ggplot}}.

   A \code{data.frame}, or other object, will override the plot
   data. All objects will be fortified to produce a data frame. See
   \code{\link{fortify}} for which variables will be created.

   A \code{function} will be called with a single argument,
   the plot data. The return value must be a \code{data.frame.}, and
   will be used as the layer data.}

\item{geom}{The geometric object to use display the data}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link{borders}}.}

\item{group}{defines grouping for variable for pareto plot, default and suggested is 1.}

\item{na.rm}{a logical value indicating whether NA values should be
stripped before the computation proceeds.}

\item{point.color}{color, used to define point color of cumulative percentage line}

\item{point.size}{number, used to define point size of cumulative percentage line}

\item{line.color}{color, used to define line color of cumulative percentage line}

\item{line.size}{color, used to define line weight of cumulative percentage line}

\item{bars.fill}{character vector length 2, start and end colors for pareto bars.}

\item{...}{other arguments passed on to \code{\link{layer}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{color = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}
}
\value{
Pareto plot.
}
\description{
stat function to create ggplot Pareto chart
}
\examples{
############################
#  Example 1: Pareto Plot  #
############################

# Load Libraries ----------------------------------------------------------
 require(ggQC)
 require(ggplot2)

# Setup Data --------------------------------------------------------------
 df <- data.frame(
                  x = letters[1:10],
                  y = as.integer(runif(n = 10, min = 0, max=100))
                 )

# Render Pareto Plot ------------------------------------------------------


ggplot(df, aes(x=x, y=y)) +
 stat_pareto(point.color = "red",
             point.size = 3,
             line.color = "black",
             #size.line = 1,
             bars.fill = c("blue", "orange"),
 )
}
