% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggInterval_centerRange.r
\name{ggInterval_centerRange}
\alias{ggInterval_centerRange}
\title{Figure with x-axis = center y-axis = range}
\usage{
ggInterval_centerRange(data = NULL,mapping = aes(NULL),plotAll=FALSE)
}
\arguments{
\item{data}{A ggESDA object. It can also be either RSDA object or
classical data frame,which will be automatically convert to ggESDA
data.}

\item{mapping}{Set of aesthetic mappings created by aes() or aes_().
If specified and inherit. aes = TRUE (the default),
it is combined with the default mapping at the top level of
the plot. You must supply mapping if there is no plot mapping.
It is the same as the mapping of ggplot2.}

\item{plotAll}{booleans, if TRUE, plot all variable together}
}
\value{
Return a ggplot2 object.
}
\description{
Visualize the relation between center and range.
}
\examples{
ggInterval_centerRange(iris,aes(iris$Sepal.Length))

mydata<-ggESDA::facedata
ggInterval_centerRange(mydata,aes(AD,col="blue",pch=2))
}
