% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/luzMetrics.R
\name{luz_metric_precision}
\alias{luz_metric_precision}
\title{luz_metric_precision}
\usage{
luz_metric_precision(
  nCls = 3,
  smooth = 1,
  mode = "multiclass",
  biThresh = 0.5,
  zeroStart = TRUE,
  clsWghts = rep(1, nCls),
  usedDS = TRUE
)
}
\arguments{
\item{nCls}{Number of classes being differentiated.}

\item{smooth}{A smoothing factor to avoid divide by zero errors. Default is 1.}

\item{mode}{Either "binary" or "multiclass". If "binary", only the logit for
the positive class prediction should be provided. If both the positive and negative
or background class probability is provided for a binary classification, use
the "multiclass" mode. Note that this package is designed to treat all predictions as multiclass.
The "binary" mode is only provided for use outside of the standard geodl workflow.}

\item{biThresh}{Probability threshold to define postive case prediction. Default is 0.5.}

\item{zeroStart}{TRUE or FALSE. If class indices start at 0 as opposed to 1, this should be set to
TRUE. This is required  to implement one-hot encoding since R starts indexing at 1. Default is TRUE.}

\item{clsWghts}{Vector of class weightings loss calculatokn. Default is equal weightings.}

\item{usedDS}{TRUE or FALSE. If deep supervision was implemented and masks are produced at varying scales using
the defineSegDataSetDS() function, this should be set to TRUE. Only the original resolution is used
to calculate assessment metrics. Default is FALSE.}
}
\value{
Calculated metric returned as a base-R vector as opposed to tensor.
}
\description{
luz_metric function to calculate macro-averaged, class aggregated precision
}
\details{
Calculates precision based on luz_metric() for use within training and validation
loops.
}
\examples{
\donttest{
library(terra)
library(torch)
#Generate example data as SpatRasters
ref <- terra::rast(matrix(sample(c(1, 2, 3), 625, replace=TRUE), nrow=25, ncol=25))
pred1 <- terra::rast(matrix(sample(c(1:150), 625, replace=TRUE), nrow=25, ncol=25))
pred2 <- terra::rast(matrix(sample(c(1:150), 625, replace=TRUE), nrow=25, ncol=25))
pred3 <- terra::rast(matrix(sample(c(1:150), 625, replace=TRUE), nrow=25, ncol=25))
pred <- c(pred2, pred2, pred3)

#Convert SpatRaster to array
ref <- terra::as.array(ref)
pred <- terra::as.array(pred)

#Convert arrays to tensors and reshape
ref <- torch::torch_tensor(ref, dtype=torch::torch_long())
pred <- torch::torch_tensor(pred, dtype=torch::torch_float32())
ref <- ref$permute(c(3,1,2))
pred <- pred$permute(c(3,1,2))

#Add mini-batch dimension
ref <- ref$unsqueeze(1)
pred <- pred$unsqueeze(1)

#Duplicate tensors to have a batch of two
ref <- torch::torch_cat(list(ref, ref), dim=1)
pred <- torch::torch_cat(list(pred, pred), dim=1)
#Calculate Macro-Averaged, Class Aggregated Precision
metric<-luz_metric_precision(nCls=3,
                             smooth=1e-8,
                             mode = "multiclass",
                             zeroStart=FALSE,
                             usedDS=FALSE)
metric<-metric$new()
metric$update(pred,ref)
metric$compute()
}
}
