% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gemini.R
\name{gemini}
\alias{gemini}
\title{Generate text from text with Gemini}
\usage{
gemini(
  prompt,
  model = "2.0-flash",
  temperature = 1,
  maxOutputTokens = 8192,
  topK = 40,
  topP = 0.95,
  seed = 1234
)
}
\arguments{
\item{prompt}{The prompt to generate text from}

\item{model}{The model to use. Options are "2.0-flash", "2.0-flash-lite", "1.5-flash", "1.5-flash-8b", "1.5-pro", Default is '2.0-flash'
see https://ai.google.dev/gemini-api/docs/models/gemini}

\item{temperature}{The temperature to use. Default is 1 value should be between 0 and 2
see https://ai.google.dev/gemini-api/docs/models/generative-models#model-parameters}

\item{maxOutputTokens}{The maximum number of tokens to generate.
Default is 8192 and 100 tokens correspond to roughly 60-80 words.}

\item{topK}{The top-k value to use. Default is 40 value should be between 0 and 100
see https://ai.google.dev/gemini-api/docs/models/generative-models#model-parameters}

\item{topP}{The top-p value to use. Default is 0.95 value should be between 0 and 1
see https://ai.google.dev/gemini-api/docs/models/generative-models#model-parameters}

\item{seed}{The seed to use. Default is 1234 value should be integer
see https://ai.google.dev/gemini-api/docs/models/generative-models#model-parameters}
}
\value{
Generated text
}
\description{
Generate text from text with Gemini
}
\examples{
\dontrun{
library(gemini.R)
setAPI("YOUR_API_KEY")
gemini("Explain dplyr's mutate function")
}
}
\seealso{
https://ai.google.dev/docs/gemini_api_overview#text_input
}
