% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdal_helpers.R
\name{dump_open_datasets}
\alias{dump_open_datasets}
\title{Report open datasets}
\usage{
dump_open_datasets()
}
\value{
Number of open datasets.
}
\description{
\code{dump_open_datasets()} dumps a list of all open datasets (shared or not) to
the console. This function is primarily intended to assist in debugging
"dataset leaks" and reference counting issues. The information reported
includes the dataset name, referenced count, shared status, driver name,
size, and band count. This a wrapper for \code{GDALDumpOpenDatasets()} with
output to the console.
}
\examples{
elev_file <- system.file("extdata/storml_elev.tif", package="gdalraster")
ds <- new(GDALRaster, elev_file)
dump_open_datasets()
ds2 <- new(GDALRaster, elev_file)
dump_open_datasets()
# open without using shared mode
ds3 <- new(GDALRaster, elev_file, read_only = TRUE,
           open_options = NULL, shared = FALSE)
dump_open_datasets()
ds$close()
dump_open_datasets()
ds2$close()
dump_open_datasets()
ds3$close()
dump_open_datasets()
}
