\name{likelihood_bounds_penalty}
\alias{g3l_bounds_penalty}
\concept{G3 action}

\title{Gadget3 likelihood bounds_penalty action}
\description{
  Add a liklihood penalty for parameters leaving the bounds set in parameter_template
}

\usage{
g3l_bounds_penalty(
        actions_or_parameter_template,
        weight = 1,
        run_at = g3_action_order$likelihood)
}

\arguments{
  \item{actions_or_parameter_template}{
    Either:

    A list of actions, to extract parameters from and to add bounds to.

    A parameter template generated by \code{\link{g3_to_tmb}}, with \var{optimise}, \var{lower}, \var{upper} populated,
    bounds for the parameters will be hard-coded.
  }
  \item{weight}{
    Weighting applied to this likelihood component.
  }
  \item{run_at}{
    Integer order that actions will be run within model, see \code{\link{g3_action_order}}.
  }
}

\details{
  Whilst lower/upper can be passed to \code{\link{optim}}, not all methods can use them.
  Adding \code{g3l_bounds_penalty} OTOH can be used with any method.
}

\value{
  \subsection{g3l_bounds_penalty}{An action (i.e. list of formula objects) that will...
    If a \var{actions} list is supplied, add a large number to likelihood when any parameter is outside bounds.
    Bounds are updated whenever \code{\link{g3_tmb_adfun}} is run.

    If a \var{parameter_template} is supplied, add a large number to likelihood when outside the bounds in the template.
    The bounds are baked into the model at this point.
  }
}

\examples{
\dontshow{library(magrittr)}
anch <- g3_stock('anch', seq(20, 156, 4)) \%>\% g3s_age(3, 10)
actions <- list(
  g3a_time(1990, 1994),
  g3a_growmature(anch, g3a_grow_impl_bbinom(
    maxlengthgroupgrowth = 38L)),
  g3a_naturalmortality(anch),
  g3a_initialconditions_normalparam(anch),
  g3a_renewal_normalparam(anch,
    run_step = NULL),
  g3a_age(anch),
  NULL)

# Generate code with bounds added
model_code <- g3_to_tmb(c(actions, list(g3l_bounds_penalty(actions))))

attr(model_code, "parameter_template") \%>\%
  # Set lower / upper bounds for initial conditions
  g3_init_val("*.init.#", 10, lower = 0.001, upper = 200) \%>\%
  identity() -> params.in

# The objective function produced by g3_tmb_adfun() will honour the bounds
# above, without having to pass them to stats::optim()
}
