% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prodSfuzzy.r
\name{prodSfuzzy}
\alias{prodSfuzzy}
\title{Product of a Scalar and a Triangular Fuzzy Number}
\usage{
prodSfuzzy(x, y)
}
\arguments{
\item{x}{numeric vector of length one.}

\item{y}{a numeric vector of length three, specifying a triangular fuzzy number as its
central value, left and right spread.}
}
\value{
Returns a numeric vector, representing a triangular fuzzy number.
}
\description{
Calculates product of a real number scalar and a triangular fuzzy number defined as a
central value, left and right spread.
}
\details{
Note that if \code{x < 0} the left and right spread will be reversed.
}
\examples{
  x <- 2
  y <- c(2, 0.2, 0.2)
  prodSfuzzy(x = x, y = y)
  x <- -2
  prodSfuzzy(x = x, y = y)
}
