% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BatchtoolsFutureBackend-class.R,
%   R/batchtools_custom.R, R/batchtools_interactive.R, R/batchtools_local.R,
%   R/batchtools_ssh.R
\name{BatchtoolsFutureBackend}
\alias{BatchtoolsFutureBackend}
\alias{BatchtoolsUniprocessFutureBackend}
\alias{BatchtoolsMultiprocessFutureBackend}
\alias{BatchtoolsCustomFutureBackend}
\alias{BatchtoolsInteractiveFutureBackend}
\alias{BatchtoolsLocalFutureBackend}
\alias{BatchtoolsBashFutureBackend}
\alias{BatchtoolsSSHFutureBackend}
\title{A batchtools future is a future whose value will be resolved via batchtools}
\usage{
BatchtoolsFutureBackend(
  workers = 1L,
  resources = list(),
  finalize = getOption("future.finalize", TRUE),
  cluster.functions = NULL,
  registry = list(),
  conf.file = findConfFile(),
  interrupts = TRUE,
  delete = getOption("future.batchtools.debug", "on-success"),
  ...
)

BatchtoolsCustomFutureBackend(...)

BatchtoolsInteractiveFutureBackend(fs.latency = 0, ...)

BatchtoolsLocalFutureBackend(fs.latency = 0, ...)

BatchtoolsSSHFutureBackend(workers = availableWorkers(), fs.latency = 65, ...)
}
\arguments{
\item{workers}{(optional) The maximum number of workers the batchtools
backend may use at any time.   Interactive and "local" backends can only
process one future at the time (\code{workers = 1}), whereas HPC backends,
where futures are resolved via separate jobs on a scheduler, can have
multiple workers. In the latter, the default is \code{workers = NULL}, which
will resolve to \code{getOption("\link{future.batchtools.workers}", 100)}.}

\item{resources}{(optional) A named list passed to the \pkg{batchtools}
job-script template as variable \code{resources}. This is based on how
\code{\link[batchtools:submitJobs]{batchtools::submitJobs()}} works, with the exception for specially
reserved names defined by the \pkg{future.batchtools} package;
\itemize{
\item \code{resources[["asis"]]} is a character vector that are passed as-is to
the job script and are injected as job resource declarations.
\item \code{resources[["modules"]]} is character vector of Linux environment
modules to be loaded.
\item \code{resources[["startup"]]} and \code{resources[["shutdown"]]} are character
vectors of shell code to be injected to the job script as-is.
\item \code{resources[["details"]]}, if TRUE, results in the job script outputting
job details and job summaries at the beginning and at the end.
\item All remaining \code{resources} named elements are injected as named resource
specification for the scheduler.
}}

\item{finalize}{If TRUE, a future's \pkg{batchtools}
\link[batchtools:makeRegistry]{Registry} is automatically deleted when
the future is garbage collected, otherwise not.}

\item{cluster.functions}{(optional) Assigned as-is to the each future's
\pkg{batchtools} \link[batchtools:makeRegistry]{Registry}.}

\item{registry}{(optional) A named list of settings applied to each
future's \pkg{batchtools} \link[batchtools:makeRegistry]{Registry}.
This is a more convenient alternative to using argument \code{conf.file}.}

\item{conf.file}{(optional) A "batchtools-configuration" R script, which
is sourced when each future's \pkg{batchtools}
\link[batchtools:makeRegistry]{Registry} is created. Any variables
created by this script is assigned to the registry.
The default file is the one found by \code{\link[batchtools:findConfFile]{batchtools::findConfFile()}}, if any.}

\item{interrupts}{If FALSE, attempts to interrupt futures will not take
place on this backend, even if the backend supports it. This is useful
when, for instance, it takes a long time to interrupt a future.}

\item{delete}{Controls if and when the batchtools job registry folder is
deleted.
If \code{"on-success"} (default), it is deleted if the future was resolved
successfully \emph{and} the expression did not produce an error.
If \code{"never"}, then it is never deleted.
If \code{"always"}, then it is always deleted.}

\item{fs.latency}{[\code{numeric(1)}]\cr
Expected maximum latency of the file system, in seconds.
Set to a positive number for network file systems like NFS which enables more robust (but also more expensive) mechanisms to
access files and directories.
Usually safe to set to \code{0} to disable the heuristic, e.g. if you are working on a local file system.}

\item{\ldots}{Additional arguments passed to \code{\link[=BatchtoolsFutureBackend]{BatchtoolsFutureBackend()}}.}
}
\value{
A \link[future:FutureBackend-class]{future::FutureBackend} object of class BatchtoolsFutureBackend

An object of class \code{BatchtoolsFuture}.

An object of class \code{BatchtoolsUniprocessFuture}.

An object of class \code{BatchtoolsMulticoreFuture}.
}
\description{
A batchtools local future is an synchronous uniprocess future that
will be evaluated in a background R session.
A batchtools interactive future is an synchronous uniprocess future
that will be evaluated in the current R session (and variables will
be assigned to the calling environment rather than to a local one).
Both types of futures will block until the futures are resolved.

A batchtools SSH future is an asynchronous multiprocess
future that will be evaluated in a background R session.\cr
\cr
\emph{We highly recommend using \link[future:multisession]{future::multisession}
(sic!) futures of the \pkg{future} package instead of
SSH batchtools futures.}
}
\details{
batchtools local futures rely on the batchtools backend set up by
\code{\link[batchtools:makeClusterFunctionsInteractive]{batchtools::makeClusterFunctionsInteractive(external = TRUE)}}
and batchtools interactive futures on the one set up by
\code{\link[batchtools:makeClusterFunctionsInteractive]{batchtools::makeClusterFunctionsInteractive()}}.
These are supported by all operating systems.

An alternative to batchtools local futures is to use
\link[future:cluster]{cluster} futures of the \pkg{future}
package with a single local background session, i.e.
\code{plan(cluster, workers = "localhost")}.

An alternative to batchtools interactive futures is to use
\code{plan(sequential, split = TRUE)} futures of the \pkg{future} package.

batchtools SSH futures rely on the batchtools backend set
up by \code{\link[batchtools:makeClusterFunctionsSSH]{batchtools::makeClusterFunctionsSSH()}}.
The batchtools SSH backend only works on operating systems
supporting the \code{ssh} and \code{ps} command-line tool, e.g. Linux and macOS.
}
\examples{
library(future)

## Create custom cluster functions (here same as "local")
cf <- batchtools::makeClusterFunctionsInteractive(external = TRUE)
print(cf)
str(cf)

# Use custom batchtools backend
plan(future.batchtools::batchtools_custom, cluster.functions = cf)
print(plan())

message("Main process ID: ", Sys.getpid())

f <- future({
  data.frame(
    hostname = Sys.info()[["nodename"]],
          os = Sys.info()[["sysname"]],
       cores = unname(parallelly::availableCores()),
         pid = Sys.getpid(),
     modules = Sys.getenv("LOADEDMODULES")
  )
})
info <- value(f)
print(info)

}
\keyword{internal}
