% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_min_diss.R
\name{.find_min_diss}
\alias{.find_min_diss}
\title{Find Minimum Dissimilarity}
\usage{
.find_min_diss(
  y,
  v,
  alpha,
  w,
  c_k,
  d,
  use0,
  use1,
  transform_y = FALSE,
  transform_v = FALSE
)
}
\arguments{
\item{y}{A list containing two matrices:
- \code{y0}: The first set of curve values \(y(x)\).
- \code{y1}: The second set of curve values \(y'(x)\).
Each matrix should have \(d\) columns corresponding to the dimensions.}

\item{v}{A list containing two matrices:
- \code{v0}: The first set of curve values \(v(x)\).
- \code{v1}: The second set of curve values \(v'(x)\).
Each matrix should have \(d\) columns corresponding to the dimensions.}

\item{alpha}{A numeric weight coefficient that balances the contributions of 
the L2 norms of the two curve sets.}

\item{w}{A numeric vector of weights for the dissimilarity index across different dimensions.
All weights must be positive (\(w > 0\)).}

\item{c_k}{An integer specifying the minimum length of the intersection of the supports 
of the shifted \(y\) and \(v\).}

\item{d}{An integer indicating the dimensionality of the curves.}

\item{use0}{A logical value indicating whether to use the first component of the curves (i.e., \(y0\) and \(v0\)).}

\item{use1}{A logical value indicating whether to use the second component of the curves (i.e., \(y1\) and \(v1\)).}

\item{transform_y}{A logical value indicating whether to normalize \(y\) to the range \([0,1]\) 
before calculating the distance.}

\item{transform_v}{A logical value indicating whether to normalize \(v\) to the range \([0,1]\) 
before calculating the distance.}
}
\value{
A numeric vector containing:
        - The optimal shift that minimizes the dissimilarity.
        - The minimum dissimilarity value found.
}
\description{
Finds the shift warping that minimizes dissimilarity between multidimensional curves. 
The function operates on curves represented by two sets of data, each containing multiple dimensions.
}
\details{
This function computes the shift warping between the provided multidimensional curves by 
examining various shifts and calculating the corresponding dissimilarity. The user can control 
which components of the curves to include in the calculation and whether to normalize the data.

The function returns both the optimal shift and the minimal dissimilarity, which can be used 
to assess the similarity between the two sets of curves under the specified constraints.
}
\author{
Marzia Angela Cremona & Francesca Chiaromonte
}
