% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_dot}
\alias{plot_dot}
\title{Dot plot}
\usage{
plot_dot(
  tbl,
  y_var,
  label,
  x_breaks = NULL,
  color = NULL,
  shape = NULL,
  title = "AE (\%)",
  background_color = c("#69B8F7", "#FFFFFF"),
  background_alpha = 0.3,
  theme = theme_panel(show_text = TRUE, show_ticks = TRUE),
  legend_nrow = 1
)
}
\arguments{
\item{tbl}{A data frame selected from input data set to display on this plot.
y and x variables are required.}

\item{y_var}{A character string that specifies a variable to be displayed
on the y-axis.}

\item{label}{A character vector of labels for each treatment group.
The control group label should be specified as the last element
of the vector.}

\item{x_breaks}{A numeric vector for x-axis breaks. Default is \code{NULL},
which uses a default ggplot2 x-axis breaks presentation.}

\item{color}{Color for each treatment group.}

\item{shape}{Shape for each treatment group. Default is circle and square.
Input values could be either a character or numeric value, For details,
see \url{https://ggplot2.tidyverse.org/articles/ggplot2-specs.html}.}

\item{title}{Panel title. Default is \code{"AE (\%)"}.}

\item{background_color}{Plot background color. Default is
\code{c("#69B8F7", "#FFFFFF")}, which are pastel blue and white.
The value of this argument is used as input for the \code{background_color}
argument in \code{\link[=background_panel]{background_panel()}}.}

\item{background_alpha}{Opacity of the background. Default is 0.3.
The value of this argument is the input for \code{background_alpha} argument in
\code{\link[=background_panel]{background_panel()}}.}

\item{theme}{Panel theme, including the y-axis text, ticks, and plot margin.
Default is \code{theme_panel(show_text = TRUE, show_ticks = TRUE)}.
For more details, refer to \code{\link{theme_panel}}.}

\item{legend_nrow}{Integer, the number of rows for a legend display.
Must be smaller than or equal to the number of the treatment groups.
To omit the legend, set this to \code{NULL}. Default is 1.}
}
\value{
AEs incidence plot by item and treatment group.
}
\description{
Create a dot plot by item. For instance, this could be used to create AEs
incidence plot by Preferred Term and treatment group, as part of a
rainfall plot.
}
\examples{
forestly_adsl$TRTA <- factor(
  forestly_adsl$TRT01A,
  levels = c("Xanomeline Low Dose", "Placebo"),
  labels = c("Low Dose", "Placebo")
)
forestly_adae$TRTA <- factor(
  forestly_adae$TRTA,
  levels = c("Xanomeline Low Dose", "Placebo"),
  labels = c("Low Dose", "Placebo")
)

meta <- meta_forestly(
  dataset_adsl = forestly_adsl,
  dataset_adae = forestly_adae,
  population_term = "apat",
  observation_term = "wk12",
  parameter_term = "any;rel;ser"
) |>
  prepare_ae_forestly() |>
  format_ae_forestly()

meta_any <- meta$tbl[1:20, ] |> dplyr::filter(parameter == "any")
meta_any |>
  dplyr::select(name, prop_1, prop_2) |>
  plot_dot("name", label = c("Treatment", "Placebo"))
}
