% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{collect_from_args}
\alias{collect_from_args}
\title{Collect attributes set in the arguments to a call expression.}
\usage{
collect_from_args(expr, attribute, condition = function(expr) TRUE,
  include_fun = FALSE)
}
\arguments{
\item{expr}{The expression to process.}

\item{attribute}{The attribute we want to collect from the arguments.}

\item{condition}{A predicate. Only arguments where the condition evaluates to
\code{TRUE} will be included in the result.}

\item{include_fun}{Include the first element in a call, i.e. the function
that will be called.}
}
\value{
A list or vector obtained by concatenating the attributes from
the arguments.
}
\description{
Given a call expression \code{expr}, this function scans the arguments to the
call and extracts the attribute \code{attribute} from each where the
\code{condition} predicate evaluates to \code{TRUE}, and it concatenates all these.
}
