% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lint.R
\name{lint}
\alias{lint}
\alias{lint_dir}
\alias{lint_package}
\alias{lint_text}
\title{List all lints in a file or a directory}
\usage{
lint(
  path = ".",
  linters = NULL,
  exclude_path = NULL,
  exclude_linters = NULL,
  open = TRUE,
  use_cache = TRUE,
  verbose = TRUE
)

lint_dir(
  path = ".",
  linters = NULL,
  open = TRUE,
  exclude_path = NULL,
  exclude_linters = NULL,
  use_cache = TRUE,
  verbose = TRUE
)

lint_package(
  path = ".",
  linters = NULL,
  open = TRUE,
  exclude_path = NULL,
  exclude_linters = NULL,
  use_cache = TRUE,
  verbose = TRUE
)

lint_text(text, linters = NULL, exclude_linters = NULL)
}
\arguments{
\item{path}{A valid path to a file or a directory. Relative paths are
accepted. If \code{NULL} (default), uses \code{"."}.}

\item{linters}{A character vector with the names of the rules to apply. See
the entire list of rules with \code{list_linters()}. If you have set up the
\code{flir} folder with \code{setup_flir()}, you can also list the linters to use
in the \code{keep} field of \code{flir/config.yml}. See \code{\link[=setup_flir]{setup_flir()}} for more
information.}

\item{exclude_path}{One or several paths that will be ignored from the \code{path}
selection.}

\item{exclude_linters}{One or several linters that will not be checked.
Values can be the names of linters (such as \code{"any_is_na"}) or its
associated function, such as \code{any_is_na_linter()} (this is mostly for
compatibility with \code{lintr}). If you have set up the \code{flir} folder with
\code{setup_flir()}, you can also list the linters to exclude in the \code{exclude}
field of \code{flir/config.yml}. See \code{\link[=setup_flir]{setup_flir()}} for more information.}

\item{open}{If \code{TRUE} (default) and if this is used in the RStudio IDE, lints
will be shown with markers.}

\item{use_cache}{Do not re-parse files that haven't changed since the last
time this function ran.}

\item{verbose}{Show messages.}

\item{text}{Text to analyze.}
}
\value{
A dataframe where each row is a lint. The columns show the text, its
location (both the position in the text and the file in which it was found)
and the severity.
}
\description{
\code{lint()}, \code{lint_text()}, \code{lint_package()}, and \code{lint_dir()} all produce a
data.frame containing the lints, their location, and potential fixes. The
only difference is in the input they take:
\itemize{
\item \code{lint()} takes path to files or directories
\item \code{lint_text()} takes some text input
\item \code{lint_dir()} takes a path to one directory
\item \code{lint_package()} takes a path to the root of a package and looks at the
following list of folders: \code{R}, \code{tests}, \code{inst}, \code{vignettes}, \code{data-raw},
\code{demo}, \code{exec}.
}
}
\section{Ignoring lines}{


\code{flir} supports ignoring single lines of code with \verb{# flir-ignore}. For
example, this will not warn:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# flir-ignore
any(duplicated(x))
}\if{html}{\out{</div>}}

However, this will warn for the second \code{any(duplicated())}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# flir-ignore
any(duplicated(x))
any(duplicated(y))
}\if{html}{\out{</div>}}

To ignore more than one line of code, use \verb{# flir-ignore-start} and
\verb{# flir-ignore-end}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# flir-ignore-start
any(duplicated(x))
any(duplicated(y))
# flir-ignore-end
}\if{html}{\out{</div>}}
}

\examples{
# `lint_text()` is convenient to explore with a small example
lint_text("any(duplicated(rnorm(5)))")

lint_text("any(duplicated(rnorm(5)))
any(is.na(x))
")

# Setup for the example with `lint()`
destfile <- tempfile()
cat("
x = c(1, 2, 3)
any(duplicated(x), na.rm = TRUE)

any(duplicated(x))

if (any(is.na(x))) {
  TRUE
}

any(
  duplicated(x)
)", file = destfile)

lint(destfile)
}
